package io.gitee.open.nw.common.base;

import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;

/**
 * 全局应用上下文
 *
 * @author CrazyZhang
 * @since 2024/3/22 13:34
 */
public class AppContext {

    private static final ThreadLocal<AppContext> CONTEXT_THREADLOCAL = new ThreadLocal<>();

    private final HashMap<String, Object> context = new HashMap<>();

    private static final Logger defaultLogger = LoggerFactory.getLogger(AppContext.class);


    public static AppContext getContext() {
        AppContext appContext = CONTEXT_THREADLOCAL.get();
        if (appContext == null) {
            appContext = new AppContext();
            appContext.context.put(Logger.class.getName(), defaultLogger);
            CONTEXT_THREADLOCAL.set(appContext);
        }
        return appContext;
    }

    public static <T> T get(Class<T> clazz) {
        return (T) getContext().context.get(clazz.getName());
    }

    public static <T> T get(String key) {
        return (T) getContext().context.get(key);
    }


    public static void set(Object t) {
        getContext().context.put(t.getClass().getName(), t);
    }

    public static void set(String key,Object t) {
        getContext().context.put(key, t);
    }

    public static void set(Class<T> clazz, Object t) {
        getContext().context.put(clazz.getName(), t);
    }

    public static void clear() {
        CONTEXT_THREADLOCAL.remove();
    }

}
