package io.gitee.open.nw.common.base;


import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 基础的服务接口
 *
 * @author CrazyZhang
 * @since 2024/3/22 13:34
 */
public interface BaseService<V, ID> {

    PageVo<V> queryPage(V param, Pageable pageable);

    List<V> queryList(V param);

    ID save(V param);

    @Transactional(rollbackFor = Exception.class)
    void update(V param);

    @Transactional(rollbackFor = Exception.class)
    void delete(ID id);

    V queryByKey(ID id);

    V queryByKeyWithCache(ID id);
}
