package io.gitee.open.nw.common.base;


import org.apache.commons.lang3.StringUtils;

/**
 * 业务异常
 *
 * @author CrazyZhang
 * @since 2024/3/22 13:34
 */
public class BizException extends RuntimeException {

    private final ResultEnum result;

    private final Object data;


    public BizException(ResultEnum result) {
        super(result.msg);
        this.result = result;
        this.data = null;
    }


    public BizException(ResultEnum result, Object data) {
        super(result.msg);
        this.data = data;
        this.result = result;
    }


    public BizException(ResultEnum result, Throwable e) {
        super(e.getMessage(), e);
        this.data = null;
        this.result = result;
    }


    public BizException(ResultEnum result, Object data, Throwable e) {
        super(e.getMessage(), e);
        this.data = data;
        this.result = result;
    }


    public BizException(ResultEnum result, String message) {
        super(message);
        this.data = null;
        this.result = result;
    }


    public BizException(ResultEnum result, Object data, String message) {
        super(message);
        this.data = data;
        this.result = result;
    }


    public BizException(ResultEnum result, String message, Throwable e) {
        super(message, e);
        this.data = null;
        this.result = result;

    }


    public BizException(ResultEnum result, Object data, String message, Throwable e) {
        super(message, e);
        this.data = data;
        this.result = result;

    }



    public Result<Object> transResult() {
        Result<Object> result = new Result<>();
        result.setCode(this.result.code);
        String message = getMessage();
        if (StringUtils.isNotBlank(message)) {
            result.setMsg(message);
        } else {
            result.setMsg(this.result.msg);
        }
        return result;
    }


    public <T> Result<T> transResult(Class<T> tClass) {
        Result<T> result = new Result<>();
        result.setCode(this.result.code);
        String message = getMessage();
        if (StringUtils.isNotBlank(message)) {
            result.setMsg(message);
        } else {
            result.setMsg(this.result.msg);
        }
        result.setData(getData(tClass));
        return result;
    }


    public ResultEnum getResult() {
        return result;
    }

    public <T> T getData(Class<T> tClass) {
        if (tClass.isInstance(data)) {
            return (T) data;
        }
        return null;
    }
}
