package io.gitee.open.nw.common.base;

import io.gitee.open.nw.common.util.BeanUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.lang.NonNull;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;

/**
 * 分页视图类
 *
 * @author CrazyZhang
 * @since 2024/3/22 13:34
 */
@Schema
public class PageVo<T> implements Serializable {

    @Serial
    private static final Long serialVersionUID = 8545996863226528798L;

    public interface ConvertCallBack<V, E> {
        List<V> doTrans(List<E> es);
    }

    public static <T> PageVo<T> buildFrom(Page<?> page, @NonNull Supplier<T> targetSupplier) {
        PageVo<T> pageVo = new PageVo<>();
        pageVo.setTotal(page.getTotalElements());
        pageVo.setSize(page.getSize());
        pageVo.setPage(page.getNumber());
        pageVo.setList(BeanUtil.convertListTo(page.getContent(), targetSupplier));
        return pageVo;
    }


    public static <V, E> PageVo<V> buildFrom(Page<E> page, @NonNull ConvertCallBack<V,E> targetSupplier) {
        PageVo<V> pageVo = new PageVo<>();
        pageVo.setTotal(page.getTotalElements());
        pageVo.setSize(page.getSize());
        pageVo.setPage(page.getNumber());
        pageVo.setList(targetSupplier.doTrans(page.getContent()));
        return pageVo;
    }

    @Parameter(hidden = true)
    @Schema(description = "结果数量", example = "88")
    private Long total;

    @NotNull
    @Schema(description = "分页条数", example = "20")
    private Integer size;

    @NotNull
    @Schema(description = "分页页码", example = "1")
    private Integer page;

    @Parameter(hidden = true)
    @Schema(description = "结果集")
    private List<T> list;

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }
}
