package io.gitee.open.nw.common.base;

/**
 * 结果枚举
 *
 * @author CrazyZhang
 * @since 2024/3/22 13:34
 */
public enum ResultEnum {

    //成功
    SUCCESS(0, "请求成功。"),

    PARAM_ERROR(101, "参数有误。"),

    //密码错误
    AUTH_LOGIN_ERROR(401, "您没有权限，请登录。"),
    //密码错误
    AUTH_LACK_ERROT(403, "您没有权限，请联系管理员。"),

    //请求路径为空
    PATH_LACK_ERROT(404, "无效的请求地址"),

    RESULT_LACK_ERROT(601, "结果为空"),

    SYSTEM_ERROT(801, "系统错误"),

    FAILD(-3, "请求失败"),

    //错误
    ERROR(1, "请求错误");



    public final Integer code;

    public final String msg;
    
    public static ResultEnum fromCode(Integer code) {
        ResultEnum[] values = values();
        for (ResultEnum value : values) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;

    }

    ResultEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }
    
    @Override
    public String toString() {
        return code + "_" + msg;
    }
}
