package io.gitee.open.nw.common.component;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.NonNull;

import java.util.ArrayList;
import java.util.List;


/**
 * spring上下文
 *
 * @author CrazyZhang
 * @since 2024/3/22 13:34
 */
public class SpringContext implements ApplicationContextAware {

   private static ApplicationContext applicationContext;

   @Override
   public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
      if (SpringContext.applicationContext == null) {
         SpringContext.applicationContext = applicationContext;
      }
   }

   public static ApplicationContext getApplicationContext() {
      return applicationContext;
   }

   public static Object getBean(String name) {
      return applicationContext.getBean(name);
   }

   public static <T> T getBean(Class<T> clazz) {
      return applicationContext.getBean(clazz);
   }

   public static <T> T getBean(String name, Class<T> clazz) {
      return applicationContext.getBean(name, clazz);
   }

   public static <T> List<T> getBeans(Class<T> clazz) {
      String[] beanNamesForType = applicationContext.getBeanNamesForType(clazz);
      ArrayList<T> values = new ArrayList<>();
      for (String beanName : beanNamesForType) {
         values.add((T)applicationContext.getBean(beanName));
      }
      return values;
   }

}
