package io.gitee.open.nw.common.util;

import io.gitee.open.nw.common.base.BizException;
import io.gitee.open.nw.common.base.ResultEnum;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ClazzUtil {


    public static <T, A extends Annotation> Field getAnnotatedFields(Class<T> tClass, Class<A> annotationClass) {
        for (Field field : tClass.getDeclaredFields()) {
            if (field.isAnnotationPresent(annotationClass)) {
                return field;
            }
        }
        throw new BizException(ResultEnum.SYSTEM_ERROT, "not found id field");
    }

    public static <T> T getValue(Field field, Object object) {
        try {
            field.setAccessible(true);
            return (T) field.get(object);
        } catch (Exception e) {
            throw new BizException(ResultEnum.SYSTEM_ERROT, "get value error");
        }
    }

    public static <T> void setValue(Field field, Object object, T value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        } catch (Exception e) {
            throw new BizException(ResultEnum.SYSTEM_ERROT, "get value error");
        }
    }

    public static <T> T createInstance(Class<T> tClass) {
        try {
            Constructor<T> constructor = tClass.getConstructor();
            return constructor.newInstance();
        } catch (Exception e) {
            throw new BizException(ResultEnum.SYSTEM_ERROT, "create bean error");
        }
    }

    public static Class<?> getSuperClassGenericType(final Class<?> clazz, final int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        } else {
            Type[] params = ((ParameterizedType) genType).getActualTypeArguments();
            if (index < params.length && index >= 0) {
                if (!(params[index] instanceof Class)) {
                    return Object.class;
                } else {
                    return (Class) params[index];
                }
            } else {
                return Object.class;
            }
        }
    }
}
