package io.gitee.open.nw.common.util;

import io.gitee.open.nw.common.base.BizException;
import io.gitee.open.nw.common.base.ResultEnum;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 日期工具
 *
 * @author CrazyZhang
 * @since 2024/3/22 13:34
 */
public class DateUtil {

    public static final String STR_DATE = "yyyy-MM-dd";

    public static final String STR_TIME = "HH:mm:ss";

    public static final String STR_STIME = "HH:mm";

    public static final String STR_TIME_NUMBER = "HHmm";

    public static final String STR_DATETIME = "yyyy-MM-dd HH:mm:ss";


    public static String getCurrenDate(String parttern){
        return DateFormatUtils.format(new Date(),parttern);
    }

    public static String addDays(String dateStr, int days,String pattern) {
        if (days == 0) {
            return dateStr;
        }
        Date date = null;
        try {
            date = DateUtils.parseDate(dateStr, pattern);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        assert date != null;
        Date resultDate = DateUtils.addDays(date, days);
        return DateFormatUtils.format(resultDate, pattern);
    }

    public static String addMonths(String dateStr, int month,String pattern) {
        if (month == 0) {
            return dateStr;
        }
        Date date = null;
        try {
            date = DateUtils.parseDate(dateStr, pattern);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        assert date != null;
        Date resultDate = DateUtils.addMonths(date, month);
        return DateFormatUtils.format(resultDate, pattern);
    }

    static final String[] WEEK_DAY_ARRAY = {"日", "一", "二", "三", "四", "五", "六"};

    public static String toWeekDay(String dateStr) {
        Date date = null;
        try {
            date = DateUtils.parseDate(dateStr, STR_DATE);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        assert date != null;
        calendar.setTime(date);
        return WEEK_DAY_ARRAY[calendar.get(Calendar.DAY_OF_WEEK) - 1];
    }

    public static String toMonthDay(String dateStr) {
        return dateStr.split("-")[2];
    }

    public static String[] getDayStrArray(String start,int num,String pattern){
        try {
            List<String> dateStrList = new ArrayList<>(16);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(DateUtils.parseDate(start,pattern));
            for (int i = 0; i < num; i++) {
                String dateStr = DateFormatUtils.format(calendar, pattern);
                dateStrList.add(dateStr);
                calendar.add(Calendar.DAY_OF_YEAR,1);
            }
            return dateStrList.toArray(new String[]{});
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String reFormat(String dateStr, String oldPattern, String newPattern) {
        Date date = null;
        try {
            date = DateUtils.parseDate(dateStr, oldPattern);
            return DateFormatUtils.format(date, newPattern);
        } catch (ParseException e) {
            throw new BizException(ResultEnum.ERROR, "格式化时间错误 " + dateStr + " 无法按 " + oldPattern + " 格式化");
        }
    }
}
