package io.gitee.open.nw.common.util;


import org.apache.commons.lang3.StringUtils;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 字符串工具
 *
 * @author CrazyZhang
 * @since 2024/3/22 13:34
 */
public class StringUtil {

    public static final String DEFAULT_CHARTSET = "UTF-8";

    private static final String REPLACE_BLANK_ENTER = "\\s{2,}|\t|\r|\n";
    private static final Pattern REPLACE_P = Pattern.compile(REPLACE_BLANK_ENTER);

    public static String replaceAllBlank(String str) {
        String dest = "";
        if (StringUtils.isNotBlank(str)) {
            Matcher m = REPLACE_P.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    /**
     * 转换为下划线
     */
    public static String camelToUnderline(String camelCaseName) {
        StringBuilder result = new StringBuilder();
        if (camelCaseName != null && camelCaseName.length() > 0) {
            result.append(camelCaseName.substring(0, 1).toLowerCase());
            for (int i = 1; i < camelCaseName.length(); i++) {
                char ch = camelCaseName.charAt(i);
                if (Character.isUpperCase(ch)) {
                    result.append("_");
                    result.append(Character.toLowerCase(ch));
                } else {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    /**
     * 转换为驼峰
     */
    public static String underlineToCamel(String underscoreName) {
        StringBuilder result = new StringBuilder();
        if (underscoreName != null && underscoreName.length() > 0) {
            boolean flag = false;
            for (int i = 0; i < underscoreName.length(); i++) {
                char ch = underscoreName.charAt(i);
                if ('_' == ch) {
                    flag = true;
                } else {
                    if (flag) {
                        result.append(Character.toUpperCase(ch));
                        flag = false;
                    } else {
                        result.append(ch);
                    }
                }
            }
        }
        return result.toString();
    }


    private static final Pattern PROCESS = Pattern.compile("\\$\\{ {0,1}.+? {0,1}}");

    /**
     * 根据模板生成生成字符串
     */
    public static String processTemplate(String template, Map<?, ?> params) {
        StringBuilder sb = new StringBuilder();
        Matcher m = PROCESS.matcher(template);
        while (m.find()) {
            String param = m.group();
            String tempObj = param.substring(2, param.length() - 1).trim();
            Object value;
            if (tempObj.contains(":")) {
                String key = tempObj.split(":")[0].trim();
                String defaultValue = tempObj.split(":")[1].trim();
                value = params.get(key);
                if (value == null) {
                    value = defaultValue;
                }
            }else{
                value = params.get(tempObj);
            }
            m.appendReplacement(sb, value.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    /**
     * 简单判断text是否为json
     *
     * @param text a {@link String} object
     * @return a boolean
     */
    public static boolean isJson(String text) {
        text = text.trim();
        return text.startsWith("{") && text.endsWith("}");
    }

    /**
     * 简单判断text是否为xml
     */
    public static boolean isXml(String text) {
        text = text.trim();
        return text.startsWith("<") && text.endsWith(">");
    }

    public static boolean isMatches(String str, String regular) {
        boolean flag = false;
        Pattern p = Pattern.compile(regular);
        Matcher m = p.matcher(str);
        if (m.matches()) {
            flag = true;
        }
        return flag;
    }

}
