package io.gitee.open.nw.common.util.encrypt;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

/**
 * aes 工具类
 *
 * @author CrazyZhang
 * @since 2024/3/22 13:34
 */
public class AesUtil {

    private static Logger logger = LoggerFactory.getLogger(AesUtil.class);


    /**
     * AES加密
     */
    public static byte[] encryptByAesCBC(byte[] sSrc, byte[] sKey, byte[] vi) throws Exception {
        if (sKey == null) {
            System.out.print("Key为空null");
            return null;
        }
        SecretKeySpec skeySpec = new SecretKeySpec(sKey, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec iv = new IvParameterSpec(vi);//使用CBC模式，需要一个向量iv，可增加加密算法的强度
        cipher.init(Cipher.ENCRYPT_MODE, skeySpec, iv);
        byte[] encrypted = cipher.doFinal(sSrc);

        return Base64Util.encode(encrypted);//此处使用BASE64做转码功能，同时能起到2次加密的作用。
    }

    /**
     * AES解密
     */
    public static byte[] decryptByAesCBC(byte[] sSrc, byte[] sKey, byte[] vi) throws Exception {
        try {
            // 判断Key是否正确
            if (sKey == null) {
                System.out.print("Key为空null");
                return null;
            }
            SecretKeySpec skeySpec = new SecretKeySpec(sKey, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec iv = new IvParameterSpec(vi);
            cipher.init(Cipher.DECRYPT_MODE, skeySpec, iv);
            byte[] encrypted1 = Base64Util.decode(sSrc);//先用base64解密
            try {
                return cipher.doFinal(encrypted1);
            } catch (Exception e) {
                logger.info("EncryptUtil-->decryptByAes AES解密失败！", e);
                return null;
            }
        } catch (Exception ex) {
            logger.info("EncryptUtil-->decryptByAes AES解密失败！", ex);
            return null;
        }
    }

    public static byte[] encryptAesGCM(byte[] data, byte[] associatedData, byte[] key, byte[] nonceStr) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, nonceStr);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(Cipher.ENCRYPT_MODE, secretKeySpec, gcmParameterSpec);
        if (associatedData != null) {
            cipher.updateAAD(associatedData);
        }
        byte[] result = cipher.doFinal(data);
        return Base64Util.encode(result);
    }

    public static byte[] decryptAesGCM(byte[] data, byte[] associatedData, byte[] key, byte[] nonceStr) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, nonceStr);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(Cipher.DECRYPT_MODE, secretKeySpec, gcmParameterSpec);
        if (associatedData != null) {
            cipher.updateAAD(associatedData);
        }
        return cipher.doFinal(Base64Util.decode(data));
    }

    public static byte[] encryptAesECB(byte[] data, byte[] key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (key == null) {
            logger.error("Key为空null");
            return null;
        }
        // 判断Key是否为16位
        if (key.length != 16) {
            logger.error("Key长度不是16位");
            return null;
        }
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");//"算法/模式/补码方式"
        cipher.init(Cipher.ENCRYPT_MODE, skeySpec);
        return cipher.doFinal(data);
    }

    public static byte[] decryptAesECB(byte[] data, byte[] key) throws Exception {
        // 判断Key是否正确
        if (key == null) {
            System.out.print("Key为空null");
            return null;
        }
        // 判断Key是否为16位
        if (key.length != 16) {
            System.out.print("Key长度不是16位");
            return null;
        }
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(Cipher.DECRYPT_MODE, skeySpec);
        try {
            return cipher.doFinal(data);
        } catch (Exception e) {
            logger.error(e.toString());
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        byte[] aesECB = encryptAesECB("123123".getBytes(StandardCharsets.UTF_8), "1111111111111111".getBytes(StandardCharsets.UTF_8));
        byte[] aesECB1 = decryptAesECB(aesECB, "1111111111111111".getBytes(StandardCharsets.UTF_8));
        System.out.println(aesECB1);
    }

}
