/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.ordinarykai.framework.sms.core.servcie.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import io.gitee.ordinarykai.framework.sms.config.SmsProperties;
import io.gitee.ordinarykai.framework.sms.core.SmsResult;
import io.gitee.ordinarykai.framework.sms.core.servcie.SmsService;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliYunSmsServiceImpl
implements SmsService {
    private static final Logger log = LoggerFactory.getLogger(AliYunSmsServiceImpl.class);
    private static final String OK = "OK";
    private static final String PRODUCT = "Dysmsapi";
    private static final String DOMAIN = "dysmsapi.aliyuncs.com";
    private final SmsProperties properties;
    private final IAcsClient acsClient;

    public AliYunSmsServiceImpl(SmsProperties smsProperties) {
        this.properties = smsProperties;
        String accessKeyId = this.properties.getAccessKeyId();
        String accessKeySecret = this.properties.getAccessKeySecret();
        DefaultProfile profile = DefaultProfile.getProfile((String)this.properties.getAliExtend().getEndPoint(), (String)accessKeyId, (String)accessKeySecret);
        DefaultProfile.addEndpoint((String)this.properties.getAliExtend().getEndPoint(), (String)PRODUCT, (String)DOMAIN);
        this.acsClient = new DefaultAcsClient((IClientProfile)profile);
    }

    @Override
    public SmsResult send(String phone, String templateKey, TreeMap<String, String> templatePrams) {
        SendSmsRequest request = new SendSmsRequest();
        request.setSysMethod(MethodType.POST);
        request.setPhoneNumbers(phone);
        request.setSignName(this.properties.getSignName());
        request.setTemplateCode(this.properties.getTemplates().get(templateKey));
        request.setTemplateParam(JSONObject.toJSONString(templatePrams));
        try {
            SendSmsResponse sendSmsResponse = (SendSmsResponse)this.acsClient.getAcsResponse((AcsRequest)request);
            if (OK.equals(sendSmsResponse.getCode())) {
                return SmsResult.success(sendSmsResponse.getCode());
            }
            log.error("send fail[code={}, message={}]", (Object)sendSmsResponse.getCode(), (Object)sendSmsResponse.getMessage());
            return SmsResult.fail(sendSmsResponse.getCode(), sendSmsResponse.getMessage());
        }
        catch (Exception e) {
            log.error("send fail", (Throwable)e);
            return SmsResult.fail(e);
        }
    }
}

