/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.ordinarykai.framework.sms.core.servcie.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import io.gitee.ordinarykai.framework.sms.config.SmsProperties;
import io.gitee.ordinarykai.framework.sms.core.SmsResult;
import io.gitee.ordinarykai.framework.sms.core.servcie.SmsService;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiYunSmsServiceImpl
implements SmsService {
    private static final Logger log = LoggerFactory.getLogger(HuaweiYunSmsServiceImpl.class);
    private static final String WSSE_HEADER_FORMAT = "UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"";
    private static final String AUTH_HEADER_VALUE = "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"";
    private final SmsProperties properties;

    public HuaweiYunSmsServiceImpl(SmsProperties smsProperties) {
        this.properties = smsProperties;
    }

    @Override
    public SmsResult send(String phone, String templateKey, TreeMap<String, String> templatePrams) {
        String url = this.properties.getHuaweiExtend().getUrl();
        String appKey = this.properties.getAccessKeyId();
        String appSecret = this.properties.getAccessKeySecret();
        String sender = this.properties.getHuaweiExtend().getSender();
        String templateId = this.properties.getTemplates().get(templateKey);
        String signature = this.properties.getSignName();
        String templateParas = MapUtil.isEmpty(templatePrams) ? "" : "[\"" + String.join((CharSequence)"\"", templatePrams.values()) + "\"]";
        String body = HuaweiYunSmsServiceImpl.buildRequestBody(sender, phone, templateId, templateParas, signature);
        String wsseHeader = null;
        try {
            wsseHeader = HuaweiYunSmsServiceImpl.buildWsseHeader(appKey, appSecret);
        }
        catch (NoSuchAlgorithmException e) {
            SmsResult.fail(e);
        }
        HttpRequest httpRequest = (HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).body(body).header(Header.CONTENT_TYPE, "application/x-www-form-urlencoded")).header("X-WSSE", wsseHeader)).header(Header.PROXY_AUTHORIZATION, AUTH_HEADER_VALUE);
        HttpResponse httpResponse = httpRequest.execute();
        String response = httpResponse.body();
        if (StringUtils.isNotBlank((CharSequence)response)) {
            String code = JSONObject.parseObject((String)response).getString("code");
            String description = JSONObject.parseObject((String)response).getString("description");
            if ("000000".equals(code)) {
                return SmsResult.success(code);
            }
            return SmsResult.fail(code, description);
        }
        return SmsResult.fail(String.valueOf(httpResponse.getStatus()), httpResponse.body());
    }

    private static String buildRequestBody(String sender, String receiver, String templateId, String templateParas, String signature) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("from", sender);
        map.put("to", receiver);
        map.put("templateId", templateId);
        map.put("templateParas", templateParas);
        map.put("signature", signature);
        return JSONObject.toJSONString(map);
    }

    private static String buildWsseHeader(String appKey, String appSecret) throws NoSuchAlgorithmException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String time = sdf.format(new Date());
        String nonce = UUID.randomUUID().toString().replace("-", "");
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update((nonce + time + appSecret).getBytes());
        byte[] passwordDigest = md.digest();
        String passwordDigestBase64Str = Base64.getEncoder().encodeToString(passwordDigest);
        return String.format(WSSE_HEADER_FORMAT, appKey, passwordDigestBase64Str, nonce, time);
    }
}

