/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.qq1134380223.guishellcore.application;

import java.io.File;
import java.time.LocalDate;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;

public abstract class GuiShellGroupMethodParam<InputFieldType, ValueType>
extends HBox {
    protected final InputFieldType inputField;

    public GuiShellGroupMethodParam(String desc, InputFieldType inputField) {
        this.inputField = inputField;
        this.getChildren().add((Object)new Label(desc + "\uff1a"));
    }

    public abstract ValueType getValue();

    public static class DirectoryParam
    extends GuiShellGroupMethodParam<DirectoryChooser, File> {
        private static final DirectoryChooser directoryChooser = new DirectoryChooser();
        private File value = null;

        public DirectoryParam(String desc) {
            super(desc, directoryChooser);
            Button button = new Button("\u9009\u62e9\u76ee\u5f55");
            button.setOnMouseClicked(event -> {
                this.value = ((DirectoryChooser)this.inputField).showDialog(this.getScene().getWindow());
            });
            this.getChildren().add((Object)button);
        }

        @Override
        public File getValue() {
            return this.value;
        }
    }

    public static class FileParam
    extends GuiShellGroupMethodParam<FileChooser, File> {
        private static final FileChooser fileChooser = new FileChooser();
        private File value = null;

        public FileParam(String desc) {
            super(desc, fileChooser);
            Button button = new Button("\u9009\u62e9\u6587\u4ef6");
            button.setOnMouseClicked(event -> {
                this.value = ((FileChooser)this.inputField).showOpenDialog(this.getScene().getWindow());
            });
            this.getChildren().add((Object)button);
        }

        @Override
        public File getValue() {
            return this.value;
        }
    }

    public static class DateParam
    extends GuiShellGroupMethodParam<DatePicker, LocalDate> {
        public DateParam(String desc) {
            super(desc, new DatePicker());
            this.getChildren().add(this.inputField);
        }

        @Override
        public LocalDate getValue() {
            return (LocalDate)((DatePicker)this.inputField).getValue();
        }
    }

    public static class MultiChoiceParam
    extends GuiShellGroupMethodParam<VBox, String[]> {
        public MultiChoiceParam(String desc, Set<String> choices) {
            super(desc, new VBox((Node[])choices.stream().map(CheckBox::new).toArray(CheckBox[]::new)));
            this.getChildren().add(this.inputField);
        }

        @Override
        public String[] getValue() {
            return (String[])((VBox)this.inputField).getChildren().stream().filter(node -> ((CheckBox)node).isSelected()).map(node -> ((CheckBox)node).getText()).toArray(String[]::new);
        }
    }

    public static class SingleChoiceParam
    extends GuiShellGroupMethodParam<ComboBox<String>, String> {
        public SingleChoiceParam(String desc, Set<String> choices) {
            super(desc, new ComboBox(FXCollections.observableArrayList(choices)));
            this.getChildren().add(this.inputField);
        }

        @Override
        public String getValue() {
            return (String)((ComboBox)this.inputField).getValue();
        }
    }

    public static class TextParam
    extends GuiShellGroupMethodParam<TextField, String> {
        public TextParam(String desc) {
            super(desc, new TextField());
            this.getChildren().add(this.inputField);
        }

        @Override
        public String getValue() {
            return ((TextField)this.inputField).getText();
        }
    }
}

