/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.qq1134380223.guishellcore.factory;

import io.gitee.qq1134380223.guishellcore.annotation.Choices;
import io.gitee.qq1134380223.guishellcore.annotation.ChoicesGenerator;
import io.gitee.qq1134380223.guishellcore.annotation.FileType;
import io.gitee.qq1134380223.guishellcore.annotation.Param;
import io.gitee.qq1134380223.guishellcore.application.GuiShellGroupMethodParam;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class GuiShellGroupMethodParamFactory {
    final Method method;
    List<Function<Parameter, GuiShellGroupMethodParam<?, ?>>> handlers = Arrays.asList(parameter -> {
        if (String.class.isAssignableFrom(parameter.getType()) && parameter.getAnnotation(Choices.class) == null) {
            return new GuiShellGroupMethodParam.TextParam(this.getDesc((Parameter)parameter));
        }
        return null;
    }, parameter -> {
        Choices choicesAnno = parameter.getAnnotation(Choices.class);
        if (String.class.isAssignableFrom(parameter.getType()) && choicesAnno != null) {
            return new GuiShellGroupMethodParam.SingleChoiceParam(this.getDesc((Parameter)parameter), this.getChoices(choicesAnno));
        }
        return null;
    }, parameter -> {
        Choices choicesAnno = parameter.getAnnotation(Choices.class);
        if (String[].class.isAssignableFrom(parameter.getType()) && choicesAnno != null) {
            return new GuiShellGroupMethodParam.MultiChoiceParam(this.getDesc((Parameter)parameter), Objects.requireNonNull(this.getChoices(choicesAnno)));
        }
        return null;
    }, parameter -> {
        if (LocalDate.class.isAssignableFrom(parameter.getType())) {
            return new GuiShellGroupMethodParam.DateParam(this.getDesc((Parameter)parameter));
        }
        return null;
    }, parameter -> {
        FileType anno = parameter.getAnnotation(FileType.class);
        if (File.class.isAssignableFrom(parameter.getType()) && (anno == null || anno.value() == FileType.Type.FILE)) {
            return new GuiShellGroupMethodParam.FileParam(this.getDesc((Parameter)parameter));
        }
        return null;
    }, parameter -> {
        FileType anno = parameter.getAnnotation(FileType.class);
        if (File.class.isAssignableFrom(parameter.getType()) && anno.value() == FileType.Type.DIRECTORY) {
            return new GuiShellGroupMethodParam.DirectoryParam(this.getDesc((Parameter)parameter));
        }
        return null;
    });

    public GuiShellGroupMethodParamFactory(Method method) {
        this.method = method;
    }

    private String getDesc(Parameter parameter) {
        Param anno = parameter.getAnnotation(Param.class);
        if (anno == null) {
            return parameter.getName();
        }
        return anno.value();
    }

    private Set<String> getChoices(Choices choicesAnno) {
        HashSet<String> choices = new HashSet<String>(Arrays.asList(choicesAnno.value()));
        Class<? extends ChoicesGenerator> choicesGenerator = choicesAnno.choicesGenerator();
        if (!choicesGenerator.isInterface()) {
            try {
                ChoicesGenerator generator = choicesGenerator.getConstructor(new Class[0]).newInstance(new Object[0]);
                choices.addAll(Arrays.asList(generator.getChoices()));
            }
            catch (Exception e) {
                choices.add("\u9009\u9879\u83b7\u53d6\u5931\u8d25");
            }
        }
        return choices;
    }

    public GuiShellGroupMethodParam<?, ?>[] getParams() {
        LinkedList list = new LinkedList();
        for (Parameter parameter : this.method.getParameters()) {
            boolean paramHandleSuccess = false;
            for (Function<Parameter, GuiShellGroupMethodParam<?, ?>> handler : this.handlers) {
                GuiShellGroupMethodParam<?, ?> param = handler.apply(parameter);
                if (param == null) continue;
                list.add(param);
                paramHandleSuccess = true;
                break;
            }
            if (paramHandleSuccess) continue;
            throw new RuntimeException(parameter.getType() + "." + parameter.getName() + "\u6709\u8bef!");
        }
        return list.toArray(new GuiShellGroupMethodParam[0]);
    }
}

