/*
 * Decompiled with CFR 0.152.
 */
package com.szc.concise.until.core.crypt;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.szc.concise.until.conf.SysCrpyProperties;
import com.szc.concise.until.core.AppContextUtil;
import com.szc.concise.until.core.crypt.CrpyCallback;
import com.szc.concise.until.core.crypt.IgnoreCryptTag;
import com.szc.concise.until.core.exception.CustomException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order(value=1)
public class DecryptRequestAop {
    private static final Logger log = LoggerFactory.getLogger(DecryptRequestAop.class);
    @Resource(type=SysCrpyProperties.class)
    private SysCrpyProperties sysCrpyProperties;

    @Pointcut(value="@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)")
    private void decryptRequestAspect() {
    }

    @Around(value="decryptRequestAspect()", argNames="joinPoint")
    protected Object aopBefore(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature;
        IgnoreCryptTag methodIgnoreCryptTag;
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        if (this.sysCrpyProperties.isConsolePrint()) {
            log.info("\u8bf7\u6c42\u8def\u5f84:{}:{};\u7c7b\u540d\u79f0:{};\u65b9\u6cd5\u540d\u79f0:{}", new Object[]{request.getMethod(), request.getRequestURI(), joinPoint.getTarget().getClass().getName(), joinPoint.getSignature().getName()});
        }
        if ((methodIgnoreCryptTag = (methodSignature = (MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(IgnoreCryptTag.class)) != null && methodIgnoreCryptTag.igDecrpy()) {
            return joinPoint.proceed();
        }
        IgnoreCryptTag classIgnoreCryptTag = joinPoint.getTarget().getClass().getAnnotation(IgnoreCryptTag.class);
        if (classIgnoreCryptTag != null && classIgnoreCryptTag.igDecrpy()) {
            return joinPoint.proceed();
        }
        Object[] original = joinPoint.getArgs();
        if (this.sysCrpyProperties.isOwnLogic()) {
            if (this.sysCrpyProperties.isConsolePrint()) {
                log.info("\u81ea\u5b9a\u4e49\u89e3\u5bc6\u65b9\u5f0f");
            }
            CrpyCallback crpyCallback = (CrpyCallback)AppContextUtil.getApplicationContext().getBean(this.sysCrpyProperties.getCallback());
            Object[] obj = crpyCallback.decrpyCallback(original);
            return joinPoint.proceed(obj);
        }
        Object[] decrypt = new Object[original.length];
        Object[] objects = this.dealWith(original, decrypt);
        if (this.sysCrpyProperties.isConsolePrint()) {
            log.info("\u8bf7\u6c42\u53c2\u6570\u89e3\u5bc6\u540e:{}", objects);
        }
        return joinPoint.proceed(objects);
    }

    @AfterReturning(pointcut="decryptRequestAspect()")
    protected void aopAfterReturning() {
    }

    @AfterThrowing(pointcut="decryptRequestAspect()", throwing="throwable")
    protected void aopAfterThrowing(Throwable throwable) {
        if (this.sysCrpyProperties.isConsolePrint()) {
            log.error("\u5f02\u5e38\u5806\u6808:{}:{}", (Object)throwable.getStackTrace()[0], (Object)throwable.getMessage());
        }
        throw new CustomException(throwable.getStackTrace()[0] + ";" + throwable.getMessage());
    }

    @After(value="decryptRequestAspect()", argNames="joinPoint")
    protected void aopAfter(JoinPoint joinPoint) {
    }

    private <T> Object[] dealWith(Object[] original, Object[] decrypt) {
        for (int i = 0; i < original.length; ++i) {
            Object data = original[i];
            decrypt[i] = this.getDecryValue(data);
        }
        return decrypt;
    }

    private <T> Object getDecryValue(Object data) {
        if (BeanUtil.isBean(data.getClass())) {
            Object t = data;
            Object[] declaredFields = t.getClass().getDeclaredFields();
            Object[] superFields = t.getClass().getSuperclass().getDeclaredFields();
            ArrayList<Object> fieldList = new ArrayList<Object>();
            if (ArrayUtil.isNotEmpty((Object[])declaredFields)) {
                fieldList.addAll(Arrays.asList(declaredFields));
            }
            if (ArrayUtil.isNotEmpty((Object[])superFields)) {
                fieldList.addAll(Arrays.asList(superFields));
            }
            for (Field field : fieldList) {
                if (field.getType() == List.class) {
                    Object fieldValue = ReflectUtil.getFieldValue((Object)t, (String)field.getName());
                    List objects = (List)fieldValue;
                    for (Object object : objects) {
                        this.getDecryValue(object);
                    }
                    continue;
                }
                Object decryStr = this.sysCrpyProperties.getDecrpyType().logic(ReflectUtil.getFieldValue((Object)t, (String)field.getName()), this.sysCrpyProperties);
                ReflectUtil.setFieldValue((Object)t, (Field)field, (Object)decryStr);
            }
            return t;
        }
        if (ObjectUtil.isBasicType((Object)data)) {
            return this.sysCrpyProperties.getDecrpyType().logic(data, this.sysCrpyProperties);
        }
        if (data instanceof List) {
            List list = (List)data;
            ArrayList<Object> enCryList = new ArrayList<Object>();
            for (Object t : list) {
                enCryList.add(this.getDecryValue(t));
            }
            return enCryList;
        }
        if (data instanceof String) {
            return this.sysCrpyProperties.getDecrpyType().logic(data, this.sysCrpyProperties);
        }
        return data;
    }
}

