/*
 * Decompiled with CFR 0.152.
 */
package com.szc.concise.until.core.crypt;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.szc.concise.until.conf.SysCrpyProperties;
import com.szc.concise.until.core.AppContextUtil;
import com.szc.concise.until.core.CommonUtil;
import com.szc.concise.until.core.crypt.CrpyCallback;
import com.szc.concise.until.core.crypt.IgnoreCryptTag;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Order(value=2)
@ControllerAdvice(annotations={RestController.class})
public class EncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(EncryptResponseBodyAdvice.class);
    private final ObjectMapper objectMapper;
    private final SysCrpyProperties sysCrpyProperties;

    @Autowired
    public EncryptResponseBodyAdvice(ObjectMapper objectMapper, SysCrpyProperties sysCrpyProperties) {
        this.objectMapper = objectMapper;
        this.sysCrpyProperties = sysCrpyProperties;
    }

    public boolean supports(MethodParameter methodParameter, Class aClass) {
        if (this.sysCrpyProperties.isOrEncrypt()) {
            Annotation[] methodAnnotations;
            IgnoreCryptTag methodAnnotation = (IgnoreCryptTag)methodParameter.getMethodAnnotation(IgnoreCryptTag.class);
            if (methodAnnotation != null) {
                return methodAnnotation.igEncrpy();
            }
            IgnoreCryptTag classAnnotation = methodParameter.getDeclaringClass().getAnnotation(IgnoreCryptTag.class);
            if (classAnnotation != null) {
                return classAnnotation.igEncrpy();
            }
            Annotation[] classAnnotations = methodParameter.getDeclaringClass().getAnnotations();
            Object[] all = (Annotation[])ArrayUtil.addAll((Object[][])new Annotation[][]{classAnnotations, methodAnnotations = methodParameter.getMethodAnnotations()});
            if (ArrayUtil.isNotEmpty((Object[])all)) {
                for (Object annotation : all) {
                    if (!(annotation instanceof ResponseBody) && !(annotation instanceof RestController)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        Charset charEncoding = this.sysCrpyProperties.getCharEncoding();
        CommonUtil.isConsolePrint(this.sysCrpyProperties.isConsolePrint(), "Charset\u683c\u5f0f:" + charEncoding + ",\u539f\u59cb\u8fd4\u56de\u6570\u636e\u4e3a:" + body);
        if (Objects.isNull(body)) {
            CommonUtil.isConsolePrint(this.sysCrpyProperties.isConsolePrint(), "\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        if (this.sysCrpyProperties.isOwnLogic()) {
            CommonUtil.isConsolePrint(this.sysCrpyProperties.isConsolePrint(), "\u81ea\u5b9a\u4e49\u89e3\u5bc6\u65b9\u5f0f");
            CrpyCallback crpyCallback = (CrpyCallback)AppContextUtil.getApplicationContext().getBean(this.sysCrpyProperties.getCallback());
            return crpyCallback.encrpyCallback(body);
        }
        return this.getBodyWriteData(body, this.sysCrpyProperties);
    }

    private Object getBodyWriteData(Object body, SysCrpyProperties sysCrpyProperties) {
        if (BeanUtil.isBean(body.getClass())) {
            JSONObject jsonObject = JSONUtil.parseObj((Object)body);
            this.getKeyData(sysCrpyProperties, jsonObject);
            return JSONUtil.toBean((JSONObject)jsonObject, body.getClass());
        }
        if (body.getClass() == String.class && JSONUtil.isJson((String)body.toString())) {
            JSONObject jsonObject = JSONUtil.parseObj((String)body.toString());
            this.getKeyData(sysCrpyProperties, jsonObject);
            return JSONUtil.toJsonStr((JSON)jsonObject);
        }
        return sysCrpyProperties.getEncrpyType().logic(StrUtil.toString((Object)body), sysCrpyProperties);
    }

    private void getKeyData(SysCrpyProperties sysCrpyProperties, JSONObject jsonObject) {
        String executeCodeName = StrUtil.blankToDefault((CharSequence)sysCrpyProperties.getExecuteCodeName(), (String)"data");
        Object data = jsonObject.get((Object)executeCodeName);
        if (!Objects.isNull(data)) {
            Object logic = sysCrpyProperties.getEncrpyType().logic(StrUtil.toString((Object)data), sysCrpyProperties);
            jsonObject.set(executeCodeName, logic);
        }
    }
}

