/*
 * Decompiled with CFR 0.152.
 */
package com.szc.concise.until.core.dict;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.szc.concise.until.conf.SysDictProperties;
import com.szc.concise.until.core.AppContextUtil;
import com.szc.concise.until.core.dict.DictCallback;
import com.szc.concise.until.core.dict.SysDictPo;
import com.szc.concise.until.core.dict.SysDictTag;
import com.szc.concise.until.core.exception.CustomException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysDictCover {
    private static final Logger log = LoggerFactory.getLogger(SysDictCover.class);
    @Resource(type=SysDictProperties.class)
    private SysDictProperties sysDictProperties;

    public <T> void convert(T data, boolean isToCode) {
        this.getDeclaredFields(isToCode, data);
    }

    public <T> void converts(List<T> data, boolean isToCode) {
        if (!CollUtil.isEmpty(data)) {
            data.parallelStream().forEach(it -> this.getDeclaredFields(isToCode, it));
        }
    }

    private <T> void getDeclaredFields(boolean isToCode, T it) {
        List<Field> fieldList = this.getAllFields(it, isToCode);
        List collect = fieldList.parallelStream().filter(item -> item.getModifiers() != 16 && item.getModifiers() != 8 && item.getModifiers() != 26).collect(Collectors.toList());
        for (Field field : collect) {
            this.getField(it, field, isToCode);
        }
    }

    private <T> List<Field> getAllFields(T it, boolean isToCode) {
        Object[] superFields = it.getClass().getSuperclass().getDeclaredFields();
        Object[] fields = it.getClass().getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        if (ArrayUtil.isNotEmpty((Object[])superFields)) {
            fieldList.addAll(Arrays.asList(superFields));
        }
        if (ArrayUtil.isNotEmpty((Object[])fields)) {
            fieldList.addAll(Arrays.asList(fields));
        }
        for (Field field : fieldList) {
            if (field.getType() != List.class) continue;
            Object fieldValue = ReflectUtil.getFieldValue(it, (String)field.getName());
            List list = (List)fieldValue;
            this.converts(list, isToCode);
        }
        return fieldList;
    }

    private <T> void getField(T data, Field field, boolean isToCode) {
        SysDictTag annotation = field.getAnnotation(SysDictTag.class);
        if (annotation != null) {
            boolean ignoreUnMatchShow = this.sysDictProperties.isIgnoreUnMatchShow();
            String code = annotation.dictCode();
            boolean orLimiter = annotation.orLimiter();
            String limiter = annotation.limiter();
            Object fieldValue = ReflectUtil.getFieldValue(data, (String)field.getName());
            if (Objects.isNull(fieldValue)) {
                log.error("\u5b57\u5178\u7f16\u7801:{},\u6570\u636e:{},\u5c5e\u6027:{}", new Object[]{code, data, field.getName()});
                this.printExecMsg("\u5c5e\u6027\u6570\u503c\u4e3a\u7a7a");
                return;
            }
            if (!ClassUtil.isBasicType(fieldValue.getClass())) {
                DictCallback dictBack = (DictCallback)AppContextUtil.getApplicationContext().getBean(this.sysDictProperties.getCallback());
                List<SysDictPo> sysDictPos = dictBack.dictCallback(code);
                if (CollUtil.isEmpty(sysDictPos)) {
                    log.error("\u68c0\u67e5\u5b57\u5178{}\u662f\u5426\u6b63\u786e,\u5b57\u5178\u6570\u636e\u4e3a\u7a7a", (Object)code);
                    this.printExecMsg(code + "\u5b57\u5178\u6570\u636e\u96c6\u5408\u4e3a\u7a7a");
                    return;
                }
                if (fieldValue instanceof List) {
                    for (Object value : (List)fieldValue) {
                        this.convert(value, isToCode);
                    }
                } else {
                    Object obj = null;
                    String value = fieldValue.toString().replaceAll(" +", ",");
                    if (StrUtil.isBlank((CharSequence)value)) {
                        log.error(field.getName() + "\u5c5e\u6027\u6570\u503c:{}", (Object)value);
                        this.printExecMsg(field.getName() + "\u5c5e\u6027\u6570\u503c\u4e3a\u7a7a");
                        return;
                    }
                    String[] values = (String[])ArrayUtil.distinct((Object[])value.split(limiter));
                    List<String> unContain = new ArrayList<String>();
                    if (isToCode) {
                        List<SysDictPo> conCollect = sysDictPos.parallelStream().filter(item -> ArrayUtil.contains((Object[])values, (Object)item.getName())).collect(Collectors.toList());
                        if (CollUtil.isNotEmpty(conCollect)) {
                            if (ignoreUnMatchShow) {
                                List collect = sysDictPos.parallelStream().map(SysDictPo::getName).collect(Collectors.toList());
                                unContain = Arrays.stream(values).filter(it -> !CollUtil.contains((Collection)collect, (Object)it)).collect(Collectors.toList());
                            }
                            obj = orLimiter ? this.getValue(isToCode, ignoreUnMatchShow, sysDictPos, conCollect, unContain, limiter) : ((SysDictPo)conCollect.get(0)).getCode();
                        }
                    } else {
                        List<SysDictPo> conCollect = sysDictPos.parallelStream().filter(item -> ArrayUtil.contains((Object[])values, (Object)item.getCode())).collect(Collectors.toList());
                        if (CollUtil.isNotEmpty(conCollect)) {
                            if (ignoreUnMatchShow) {
                                List collect = sysDictPos.parallelStream().map(SysDictPo::getCode).collect(Collectors.toList());
                                unContain = Arrays.stream(values).filter(it -> !CollUtil.contains((Collection)collect, (Object)it)).collect(Collectors.toList());
                            }
                            obj = orLimiter ? this.getValue(isToCode, ignoreUnMatchShow, sysDictPos, conCollect, unContain, limiter) : ((SysDictPo)conCollect.get(0)).getName();
                        }
                    }
                    if (Objects.isNull(obj)) {
                        log.error(field.getName() + "\u8f6c\u7684\u6362\u6570\u503c\u4e3a\u7a7a");
                        this.printExecMsg(field.getName() + "\u8f6c\u7684\u6362\u6570\u503c\u4e3a\u7a7a");
                        return;
                    }
                    if (!Objects.equals(value, obj)) {
                        ReflectUtil.setFieldValue(data, (Field)field, (Object)obj);
                    }
                }
            }
        }
    }

    private Object getValue(boolean isToCode, boolean ignoreUnMatchShow, List<SysDictPo> sysDictPos, List<SysDictPo> conCollect, List<String> unContain, String limiter) {
        String obj;
        if (ignoreUnMatchShow) {
            List collect = isToCode ? conCollect.parallelStream().map(SysDictPo::getCode).collect(Collectors.toList()) : conCollect.parallelStream().map(SysDictPo::getName).collect(Collectors.toList());
            collect.addAll(unContain);
            obj = collect.parallelStream().collect(Collectors.joining(limiter));
        } else {
            obj = isToCode ? sysDictPos.parallelStream().map(SysDictPo::getCode).collect(Collectors.joining(limiter)) : sysDictPos.parallelStream().map(SysDictPo::getName).collect(Collectors.joining(limiter));
        }
        return obj;
    }

    private void printExecMsg(String execMsg) {
        if (!this.sysDictProperties.isIgnoreExec()) {
            throw new CustomException(execMsg);
        }
    }
}

