/*
 * Decompiled with CFR 0.152.
 */
package com.szc.concise.until.core.oplog;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.szc.concise.until.conf.SysOpLogProperties;
import com.szc.concise.until.core.AppContextUtil;
import com.szc.concise.until.core.exception.CustomException;
import com.szc.concise.until.core.oplog.CodeEnum;
import com.szc.concise.until.core.oplog.OpLogCallback;
import com.szc.concise.until.core.oplog.SysOpLog;
import com.szc.concise.until.core.oplog.SystemOpLogTag;
import com.szc.concise.until.core.result.ResultEnum;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.validation.BindingResult;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

@Aspect
@Order(value=5)
public class SystemOpLogAop
implements EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(SystemOpLogAop.class);
    @Resource(type=SysOpLogProperties.class)
    private SysOpLogProperties sysOpLogProperties;
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Pointcut(value="@annotation(SystemOpLogTag)")
    private void sysLogAspect() {
    }

    @Around(value="sysLogAspect() && @annotation(systemOpLogTag)")
    protected Object around(ProceedingJoinPoint joinPoint, SystemOpLogTag systemOpLogTag) {
        SysOpLog sysOpLog = new SysOpLog();
        try {
            Date beginDate = new Date();
            sysOpLog.setOrNormal(true);
            sysOpLog.setBeginDate(beginDate);
            this.getSysLog(joinPoint, sysOpLog);
            Object result = joinPoint.proceed();
            if (JSONUtil.isJson((String)(result + ""))) {
                Object resultCode = JSONUtil.parseObj((Object)result).getOrDefault((Object)this.sysOpLogProperties.getExecuteCodeName(), (Object)CodeEnum.DEFAULT.getCode());
                sysOpLog.setExecuteCode(String.valueOf(resultCode));
            }
            Object[] resultObj = new Object[]{result};
            String resultJson = this.toJson(resultObj);
            sysOpLog.setExecuteResult(resultJson);
            sysOpLog.setCreateTime(new Date());
            Date endDate = new Date();
            sysOpLog.setEndDate(endDate);
            long between = DateUtil.between((Date)beginDate, (Date)endDate, (DateUnit)DateUnit.MINUTE);
            sysOpLog.setIntervalsTime(between + "");
            if (this.sysOpLogProperties.isConsolePrint()) {
                log.info("\u64cd\u4f5c\u8bb0\u5f55----->{}", (Object)sysOpLog);
            }
            this.callback(sysOpLog);
            return result;
        }
        catch (Throwable throwable) {
            if (this.sysOpLogProperties.isConsolePrint()) {
                log.error("\u5f02\u5e38\u5806\u6808:{}:{}", (Object)throwable.getStackTrace()[0], (Object)throwable.getMessage());
            }
            StrBuilder strBuilder = new StrBuilder();
            strBuilder.append((CharSequence)"\u5f02\u5e38--->\u7c7b:").append((CharSequence)throwable.getStackTrace()[0].getClassName()).append((CharSequence)";\u8bf7\u6c42\u8def\u5f84:").append((CharSequence)sysOpLog.getHttpUri()).append((CharSequence)";\u65b9\u6cd5:").append((CharSequence)throwable.getStackTrace()[0].getMethodName()).append((CharSequence)";\u884c\u6570:").append((Object)throwable.getStackTrace()[0].getLineNumber()).append((CharSequence)";\u4fe1\u606f:").append((CharSequence)throwable.getMessage());
            sysOpLog.setExecuteCode(ResultEnum.SERVER_FAIL.getCode() + "");
            sysOpLog.setOrNormal(false);
            sysOpLog.setStack(strBuilder.toString());
            this.callback(sysOpLog);
            throw new CustomException(throwable.getStackTrace()[0] + ";" + throwable.getMessage());
        }
    }

    private void callback(SysOpLog sysOpLog) {
        ((OpLogCallback)AppContextUtil.getApplicationContext().getBean(this.sysOpLogProperties.getCallback())).opCallback(sysOpLog);
    }

    private void getSysLog(ProceedingJoinPoint joinPoint, SysOpLog sysOpLog) {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        String uri = request.getRequestURI();
        String method = request.getMethod();
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] args = joinPoint.getArgs();
        String argsJson = this.toJson(args);
        String ip = SystemOpLogAop.getIp(request);
        sysOpLog.setOperatorIp(ip);
        sysOpLog.setHttpUri(uri);
        sysOpLog.setHttpStyle(method);
        sysOpLog.setClassName(className);
        sysOpLog.setMethodName(methodName);
        sysOpLog.setOperateParameter(argsJson);
        Method signature = ((MethodSignature)joinPoint.getSignature()).getMethod();
        SystemOpLogTag tag = signature.getAnnotation(SystemOpLogTag.class);
        String appName = "";
        if (StrUtil.isNotBlank((CharSequence)tag.appName())) {
            String name = this.environment.resolvePlaceholders(tag.appName());
            appName = StrUtil.isNotBlank((CharSequence)tag.appName()) ? name : tag.appName();
        }
        sysOpLog.setAppName(appName);
        sysOpLog.setModuleName(tag.moduleName());
        sysOpLog.setMenuName(tag.menuName());
        sysOpLog.setOperaName(tag.operaName());
    }

    private String toJson(Object[] args) {
        StringBuilder sr = new StringBuilder();
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                if (arg instanceof HttpServletRequest || arg instanceof HttpServletResponse) continue;
                if (arg instanceof BindingResult) {
                    arg = ((BindingResult)arg).getFieldErrors();
                }
                if (arg instanceof MultipartFile) {
                    arg = ((MultipartFile)arg).getOriginalFilename();
                }
                if (arg instanceof MultipartFile[]) {
                    MultipartFile[] multipartFiles = (MultipartFile[])arg;
                    arg = Arrays.stream(multipartFiles).map(MultipartFile::getOriginalFilename).collect(Collectors.joining(","));
                }
                if (arg instanceof StandardMultipartHttpServletRequest) {
                    arg = ((StandardMultipartHttpServletRequest)arg).getParameterMap();
                }
                sr.append(JSONUtil.toJsonStr((Object)arg)).append(";");
            }
        }
        return sr.toString();
    }

    private static String getIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        String unknown = "unknown";
        if (!StrUtil.isBlank((CharSequence)ip) && !unknown.equalsIgnoreCase(ip)) {
            int index = ip.indexOf(44);
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (!StrUtil.isBlank((CharSequence)ip) && !unknown.equalsIgnoreCase(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }
}

