/*
 * Decompiled with CFR 0.152.
 */
package com.szc.concise.core.dict;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.szc.concise.conf.SysDictProperties;
import com.szc.concise.core.dict.DictCallback;
import com.szc.concise.core.dict.SysDictPo;
import com.szc.concise.core.dict.SysDictTag;
import com.szc.concise.core.untils.AppContextUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysDictCover {
    private static final Logger log = LoggerFactory.getLogger(SysDictCover.class);
    @Resource(type=SysDictProperties.class)
    private SysDictProperties sysDictProperties;

    public <T> void attrConvert(T data) {
        this.coverConvert(data, false);
    }

    public <T> void attrConverts(List<T> data) {
        this.coverConverts(data, false);
    }

    public <T> void coverConvert(T data, boolean isToCode) {
        this.getDeclaredFields(isToCode, data);
    }

    public <T> void coverConverts(List<T> data, boolean isToCode) {
        if (!CollUtil.isEmpty(data)) {
            data.forEach(it -> this.getDeclaredFields(isToCode, it));
        }
    }

    private <T> void getDeclaredFields(boolean isToCode, T it) {
        List<Field> fieldList = this.getAllFields(it);
        List collect = fieldList.stream().filter(item -> item.getModifiers() != 16 && item.getModifiers() != 8 && item.getModifiers() != 26).collect(Collectors.toList());
        for (Field field : collect) {
            this.getField(it, field, isToCode);
        }
    }

    private <T> List<Field> getAllFields(T it) {
        Object[] superFields = it.getClass().getSuperclass().getDeclaredFields();
        Object[] fields = it.getClass().getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        if (ArrayUtil.isNotEmpty((Object[])superFields)) {
            fieldList.addAll(Arrays.asList(superFields));
        }
        if (ArrayUtil.isNotEmpty((Object[])fields)) {
            fieldList.addAll(Arrays.asList(fields));
        }
        return fieldList;
    }

    private <T> void getField(T data, Field field, boolean isToCode) {
        SysDictTag annotation;
        if (List.class.equals(field.getType())) {
            Object fieldValue = ReflectUtil.getFieldValue(data, (String)field.getName());
            List list = (List)fieldValue;
            this.coverConverts(list, isToCode);
        }
        if (ObjectUtil.isNotNull((Object)(annotation = field.getAnnotation(SysDictTag.class)))) {
            Object fieldValue = ReflectUtil.getFieldValue(data, (String)field.getName());
            if (ObjectUtil.isNull((Object)fieldValue) || ObjectUtil.isEmpty((Object)fieldValue)) {
                log.warn(field.getName() + ":\u5c5e\u6027\u6570\u503c\u4e3a\u7a7a");
                return;
            }
            String dictCode = annotation.dictCode();
            if (StrUtil.isBlank((CharSequence)dictCode)) {
                log.warn(dictCode + ":code\u6570\u503c\u4e3a\u7a7a");
                return;
            }
            DictCallback dictBack = (DictCallback)AppContextUtil.getApplicationContext().getBean(this.sysDictProperties.getCallback());
            List<SysDictPo> sysDictPos = dictBack.dictCallback(dictCode, field, fieldValue);
            if (CollUtil.isEmpty(sysDictPos)) {
                log.warn("\u68c0\u67e5\u5b57\u5178{}\u662f\u5426\u6b63\u786e,\u5b57\u5178\u6570\u636e\u4e3a\u7a7a", (Object)dictCode);
                return;
            }
            this.sysDictProperties.getCoverType().logic(this.sysDictProperties, annotation, isToCode, data, field, sysDictPos);
        }
    }
}

