/*
 * Decompiled with CFR 0.152.
 */
package com.szc.concise.core.dict;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.szc.concise.conf.SysDictProperties;
import com.szc.concise.core.dict.SysDictPo;
import com.szc.concise.core.dict.SysDictTag;
import com.szc.concise.core.untils.StreamUntil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SysDictEnum {
    COVER("cover", ""){

        @Override
        protected <T> void logic(SysDictProperties sysDictProperties, SysDictTag annotation, boolean isToCode, T data, Field field, List<SysDictPo> sysDictPos) {
            this.setFieldValue(COVER, annotation, isToCode, data, field, sysDictPos);
        }
    }
    ,
    ATTRIBUTE("attribute", "Tag"){

        @Override
        protected <T> void logic(SysDictProperties sysDictProperties, SysDictTag annotation, boolean isToCode, T data, Field field, List<SysDictPo> sysDictPos) {
            String prefix = this.getPrefix();
            String dictFieldName = field.getName() + prefix;
            Field dictField = ReflectUtil.getField(data.getClass(), (String)dictFieldName);
            if (ObjectUtil.isNull((Object)dictField)) {
                log.warn("Please add Field {} in {}", (Object)dictFieldName, data.getClass());
            } else {
                this.setFieldValue(ATTRIBUTE, annotation, isToCode, data, field, sysDictPos);
            }
        }
    };

    private static final Logger log;
    private final String coverType;
    private final String prefix;

    private SysDictEnum(String coverType, String prefix) {
        this.coverType = coverType;
        this.prefix = prefix;
    }

    protected <T> void logic(SysDictProperties sysDictProperties, SysDictTag annotation, boolean isToCode, T data, Field field, List<SysDictPo> sysDictPos) {
    }

    @Deprecated
    List<String> getGroup(boolean isToCode, List<SysDictPo> sysDictPos, List<String> fieldValues) {
        LinkedList<String> vList = new LinkedList<String>();
        Map<String, List<SysDictPo>> group = isToCode ? sysDictPos.stream().filter(StreamUntil.distByAttr(SysDictPo::getName)).collect(Collectors.groupingBy(SysDictPo::getName)) : sysDictPos.stream().filter(StreamUntil.distByAttr(SysDictPo::getCode)).collect(Collectors.groupingBy(SysDictPo::getCode));
        for (String fieldValue : fieldValues) {
            List<SysDictPo> list = group.get(fieldValue);
            if (CollUtil.isNotEmpty(list)) {
                List collect = isToCode ? list.stream().filter(StreamUntil.distByAttr(SysDictPo::getCode)).map(SysDictPo::getCode).collect(Collectors.toList()) : list.stream().filter(StreamUntil.distByAttr(SysDictPo::getName)).map(SysDictPo::getName).collect(Collectors.toList());
                vList.addAll(collect);
                continue;
            }
            vList.add(fieldValue);
        }
        return vList;
    }

    @Deprecated
    <T> void setFieldValue(SysDictEnum sysDictEnum, SysDictTag annotation, boolean isToCode, T data, Field field, List<SysDictPo> sysDictPos) {
        if (String.class.equals(field.getType()) || Object.class.equals(field.getType())) {
            String limiter = annotation.limiter();
            Object fieldValue = ReflectUtil.getFieldValue(data, (String)field.getName());
            String[] values = (String[])ArrayUtil.distinct((Object[])fieldValue.toString().split(limiter));
            List<String> reBlank = Arrays.stream(values).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
            if (CollUtil.isEmpty(reBlank)) {
                log.warn("coverType:{},{}:\u5c5e\u6027\u6570\u503c\u4e3a\u7a7a", (Object)sysDictEnum, (Object)field.getName());
                return;
            }
            List<String> group = this.getGroup(isToCode, sysDictPos, reBlank);
            ReflectUtil.setFieldValue(data, (String)(field.getName() + sysDictEnum.getPrefix()), (Object)String.join((CharSequence)",", group));
        } else {
            log.error("Please set {} \u6570\u636e\u7c7b\u578b\u4e3a 'String' or 'Object'", (Object)field.getName());
        }
    }

    public String getCoverType() {
        return this.coverType;
    }

    public String getPrefix() {
        return this.prefix;
    }

    static {
        log = LoggerFactory.getLogger(SysDictEnum.class);
    }
}

