/*
 * Decompiled with CFR 0.152.
 */
package com.szc.concise.core.rex;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.szc.concise.conf.SysGlobalRexProperties;
import com.szc.concise.core.rex.RexCallBack;
import com.szc.concise.core.untils.AppContextUtil;
import java.beans.PropertyEditor;
import java.lang.annotation.Annotation;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class GlobalRex
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(GlobalRex.class);
    @Resource(type=SysGlobalRexProperties.class)
    private SysGlobalRexProperties sysGlobalRexProperties;

    @ExceptionHandler(value={Throwable.class})
    public Object exceptionHandler(Throwable throwable, HttpServletRequest request) {
        if (this.sysGlobalRexProperties.isConsolePrint()) {
            throwable.printStackTrace();
        }
        RexCallBack rexCallBack = (RexCallBack)AppContextUtil.getApplicationContext().getBean(this.sysGlobalRexProperties.getRexCustomBack());
        return rexCallBack.exceptionHandler(throwable, request);
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, false));
    }

    public boolean supports(MethodParameter methodParameter, Class aClass) {
        Annotation[] all;
        if (!this.sysGlobalRexProperties.isEnable()) {
            return false;
        }
        Annotation[] classAnnotations = methodParameter.getDeclaringClass().getAnnotations();
        Annotation[] methodAnnotations = methodParameter.getMethodAnnotations();
        for (Annotation annotation : all = (Annotation[])ArrayUtil.addAll((Object[][])new Annotation[][]{classAnnotations, methodAnnotations})) {
            if (!(annotation instanceof ResponseBody) && !(annotation instanceof RestController)) continue;
            return true;
        }
        return false;
    }

    public Object beforeBodyWrite(Object body, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> httpMessageConverter, ServerHttpRequest request, ServerHttpResponse response) {
        String[] split;
        String defIgnore;
        String ignoreReturnWhitelist = defIgnore = "/doc.html,/swagger-ui.html,/webjars/**,/v2/**,/swagger*/**,";
        if (StrUtil.isNotBlank((CharSequence)this.sysGlobalRexProperties.getIgnoreReturnWhitelist())) {
            ignoreReturnWhitelist = defIgnore + this.sysGlobalRexProperties.getIgnoreReturnWhitelist();
        }
        String requestUri = ((ServletServerHttpRequest)request).getServletRequest().getServletPath();
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        for (String uri : split = ignoreReturnWhitelist.split(",")) {
            boolean match = antPathMatcher.match(uri, requestUri);
            if (!match) continue;
            return body;
        }
        RexCallBack rexCallBack = (RexCallBack)AppContextUtil.getApplicationContext().getBean(this.sysGlobalRexProperties.getRexCustomBack());
        return rexCallBack.beforeBodyWrite(body, methodParameter, mediaType, httpMessageConverter, request, response);
    }
}

