/*
 * Decompiled with CFR 0.152.
 */
package com.szc.concise.core.rex;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.szc.concise.core.rex.R;
import com.szc.concise.core.rex.Result;
import com.szc.concise.core.rex.ResultEnum;
import com.szc.concise.core.rex.RexCallBack;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;

public class SysRexCallBack
implements RexCallBack {
    private static final Logger log = LoggerFactory.getLogger(SysRexCallBack.class);
    @Resource
    private ObjectMapper objectMapper;

    @Override
    public Object exceptionHandler(Throwable throwable, HttpServletRequest request) {
        return R.fail(ResultEnum.SERVER_FAIL.getCode(), throwable.getStackTrace()[0] + throwable.getMessage());
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> httpMessageConverter, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof String) {
            return this.objectMapper.writeValueAsString(R.success(body));
        }
        if (body instanceof Result) {
            return body;
        }
        return R.success(body);
    }
}

