/*
 * Decompiled with CFR 0.152.
 */
package org.artifact.csv;

import cn.hutool.core.text.csv.CsvData;
import cn.hutool.core.text.csv.CsvReadConfig;
import cn.hutool.core.text.csv.CsvReader;
import cn.hutool.core.text.csv.CsvRow;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.artifact.csv.CsvField;

public class CsvBean {
    private String name;
    private List<CsvField> fields = new ArrayList<CsvField>();
    private String ext;

    public CsvBean(File file, String ext) {
        CsvReadConfig config = new CsvReadConfig();
        config.setFieldSeparator(';');
        CsvReader reader = new CsvReader(config);
        CsvData csv = reader.read(file);
        String fileName = StrUtil.removeSuffix((CharSequence)file.getName(), (CharSequence)".csv");
        fileName = StrUtil.toCamelCase((CharSequence)fileName);
        this.name = fileName = StrUtil.upperFirst((CharSequence)fileName);
        List rows = csv.getRows();
        CsvRow names = (CsvRow)rows.get(0);
        CsvRow types = (CsvRow)rows.get(1);
        CsvRow remarks = (CsvRow)rows.get(2);
        CsvRow owns = (CsvRow)rows.get(3);
        for (int i = 0; i < names.size(); ++i) {
            String own = owns.get(i);
            if (!StrUtil.containsIgnoreCase((CharSequence)own, (CharSequence)"s")) continue;
            CsvField field = new CsvField();
            field.setName(names.get(i));
            field.setType(types.get(i));
            field.setRemark(remarks.get(i));
            this.fields.add(field);
        }
        this.ext = ext;
    }

    public String getName() {
        return this.name;
    }

    public List<CsvField> getFields() {
        return this.fields;
    }

    public String getExt() {
        return this.ext;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFields(List<CsvField> fields) {
        this.fields = fields;
    }

    public void setExt(String ext) {
        this.ext = ext;
    }
}

