/*
 * Decompiled with CFR 0.152.
 */
package org.artifact.csv;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.artifact.csv.CsvBean;

public class CsvBuilder {
    private TemplateConfig templateConfig;
    private String sourcePath;
    private String packageName;
    private String designSourcePath;
    private Map<String, String> exts = new HashMap<String, String>();

    public void useDefaultGroupTemplate() {
        this.templateConfig = new TemplateConfig();
        this.templateConfig.setCharset(CharsetUtil.CHARSET_UTF_8);
        this.templateConfig.setResourceMode(TemplateConfig.ResourceMode.CLASSPATH);
    }

    public void exec() throws Exception {
        if (this.templateConfig == null) {
            this.useDefaultGroupTemplate();
        }
        if (StrUtil.isBlank((CharSequence)this.sourcePath) || StrUtil.isBlank((CharSequence)this.packageName) || this.designSourcePath == null) {
            throw new IllegalStateException("\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        this.check();
        this.execute();
        CsvBuilder.completeInfo();
    }

    private void execute() {
        TemplateEngine engine = TemplateUtil.createEngine((TemplateConfig)this.templateConfig);
        Template template = engine.getTemplate("csv.btl");
        List files = FileUtil.loopFiles((String)this.designSourcePath, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return StrUtil.endWith((CharSequence)pathname.getName(), (CharSequence)".csv");
            }
        });
        ArrayList<CsvBean> csvs = new ArrayList<CsvBean>();
        for (File file : files) {
            CsvBean csv = new CsvBean(file, this.exts.getOrDefault(file.getName(), ""));
            HashMap<String, Object> bindingMap = new HashMap<String, Object>();
            bindingMap.put("csv", csv);
            bindingMap.put("packageName", this.packageName);
            bindingMap.put("fileName", file.getName());
            csvs.add(csv);
            String pathname = this.sourcePath + File.separator + csv.getName() + "Csv.java";
            this.render(pathname, template, bindingMap);
        }
    }

    private void render(String path, Template template, Map<String, Object> bindingMap) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(new File(path));
            template.render(bindingMap, (Writer)fileWriter);
            fileWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void check() {
        if (!FileUtil.isDirectory((File)new File(this.designSourcePath))) {
            throw new IllegalStateException("\u4e0d\u662f\u76ee\u5f55");
        }
        File file = new File(this.sourcePath);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
    }

    public static void completeInfo() {
        System.out.println("*********************************************");
        System.out.println("*                                           *");
        System.out.println("**********\u4ee3\u7801\u751f\u6210\u5b8c\u6210-\u8bf7\u5237\u65b0\u9879\u76ee\uff01**********");
        System.out.println("*                                           *");
        System.out.println("*********************************************");
        System.exit(0);
    }

    CsvBuilder(TemplateConfig templateConfig, String sourcePath, String packageName, String designSourcePath, Map<String, String> exts) {
        this.templateConfig = templateConfig;
        this.sourcePath = sourcePath;
        this.packageName = packageName;
        this.designSourcePath = designSourcePath;
        this.exts = exts;
    }

    public static CsvBuilderBuilder builder() {
        return new CsvBuilderBuilder();
    }

    public static class CsvBuilderBuilder {
        private TemplateConfig templateConfig;
        private String sourcePath;
        private String packageName;
        private String designSourcePath;
        private Map<String, String> exts;

        CsvBuilderBuilder() {
        }

        public CsvBuilderBuilder templateConfig(TemplateConfig templateConfig) {
            this.templateConfig = templateConfig;
            return this;
        }

        public CsvBuilderBuilder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public CsvBuilderBuilder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public CsvBuilderBuilder designSourcePath(String designSourcePath) {
            this.designSourcePath = designSourcePath;
            return this;
        }

        public CsvBuilderBuilder exts(Map<String, String> exts) {
            this.exts = exts;
            return this;
        }

        public CsvBuilder build() {
            return new CsvBuilder(this.templateConfig, this.sourcePath, this.packageName, this.designSourcePath, this.exts);
        }

        public String toString() {
            return "CsvBuilder.CsvBuilderBuilder(templateConfig=" + this.templateConfig + ", sourcePath=" + this.sourcePath + ", packageName=" + this.packageName + ", designSourcePath=" + this.designSourcePath + ", exts=" + this.exts + ")";
        }
    }
}

