package com.baomidou.mybatisplus.extension.parser;

import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
  * JsqlParser
  *
  * @author sunpeng
  * @date 2023/6/6
  */
public class JsqlParser {

    private static final Logger logger = LoggerFactory.getLogger(JsqlParser.class);

    public static void main(String[] args) throws JSQLParserException {
        String sql1 = "select 1 from dual where a=b";
        String sql2 = "select t1.name, t2.address from Table1 t1 inner join Table2 t2 on t1.id = t2.id;";
        String sql3 = "select t1.name, t2.address from Table1 t1 join Table2 t2 on t1.id = t2.id;";
        String sql4 = "select t1.name, t2.address from Table1 t1 left join Table2 t2 on t1.id = t2.id;";
        String sql5 = "select t1.name, t2.address from Table1 t1 right join Table2 t2 on t1.id = t2.id;";
        String sql6 = "SELECT * FROM user_001 AS s WHERE id = (SELECT u.id FROM student_001 AS s INNER JOIN grade_001 AS  g ON u.id = g.id WHERE name = (SELECT name FROM user_001 AS  s2 WHERE id = 2))";
        String sql7 = "select 1 from dual where a=b;select 1 from dual where a111=b222;";

        getSqlByUpdateSchemaName(sql1, "aaa");
        getSqlByUpdateSchemaName(sql2, "bbb");
        getSqlByUpdateSchemaName(sql3, "haha");
        getSqlByUpdateSchemaName(sql4, "hehe");
        getSqlByUpdateSchemaName(sql5, "hehe");
        getSqlByUpdateSchemaName(sql6, "hehe");
        getSqlByUpdateSchemaName(sql7, "hehe");
    }

    public static Set<String> getTableNames(String sql) {
        Set<String> tableNames = null;

        try {
            Statements statements = CCJSqlParserUtil.parseStatements(sql);

            TablesNamesFinder tnf = new TablesNamesFinder();
            tableNames = statements.getStatements().stream().filter(Objects::nonNull).map(tnf::getTableList).flatMap(Collection::stream).collect(Collectors.toSet());
        } catch (Exception e) {
            e.printStackTrace();
        }

        return tableNames;
    }

    /**
     * sql 动态替换 模式名称
     *
     * @param sql
     * @param schemaName
     * @return
     */
    public static String getSqlByUpdateSchemaName(String sql, String schemaName) {
        String sqlNew = null;

        try {
            Statements statements = CCJSqlParserUtil.parseStatements(sql);

            statements.getStatements().forEach(statement -> {
                TablesNamesFinder tnf = new JsqlParserForUpdateSchemaName(schemaName);
                tnf.getTableList(statement);
            });

            sqlNew = statements.toString();
        } catch (Exception e) {
            logger.error("getSqlByUpdateSchemaName err", e);
        }

        return sqlNew;
    }
}
