package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.extension.parser.JsqlParser;
import lombok.Data;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.sql.Connection;

/**
  * 动态切换数据库模式
  *
  * @author sunpeng
  * @date 2023/6/6
  */
@Data
@SuppressWarnings({"rawtypes"})
public class SchemaNameInnerInterceptor implements InnerInterceptor {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private String schemaName;

    //是否打印sql
    //0不打印   1打印：仅原始sql   2打印：仅转换后的sql   3打印：原始sql + 转换后的sql
    private int printSql = 0;

    public SchemaNameInnerInterceptor(String schemaName) {
        this.schemaName = schemaName;
    }

    public SchemaNameInnerInterceptor(String schemaName, int printSql) {
        this.schemaName = schemaName;
        this.printSql = printSql;
    }

    @Override
    public void beforePrepare(StatementHandler sh, Connection conn, Integer transactionTimeout) {
        String sqlOrig = "";
        String sqlNew = "";

        try {
            BoundSql boundSql = sh.getBoundSql();

            sqlOrig = boundSql.getSql();
            sqlNew = JsqlParser.getSqlByUpdateSchemaName(sqlOrig, schemaName);

            Field field = boundSql.getClass().getDeclaredField("sql");
            field.setAccessible(true);
            field.set(boundSql, sqlOrig);

            if (printSql == 0) {

            } else if (printSql == 1) {
                logger.info("sql orig : {}", sqlOrig);

            } else if (printSql == 2) {
                logger.info("sql new : {}", sqlNew);

            } else {
                logger.info("sql orig : {}, sql new : {}", sqlOrig, sqlNew);
            }
        } catch (Exception e) {
            logger.error("sql orig : {}, sql new : {}", sqlOrig, sqlNew, e);
        }
    }
}
