package org.sophon.module.sms.api;

import java.util.Collection;
import java.util.List;

import org.sophon.commons.pager.PageResult;
import org.sophon.module.sms.api.vo.channel.SmsChannelCreateOrUpdateReq;
import org.sophon.module.sms.api.vo.channel.SmsChannelPageReq;
import org.sophon.module.sms.api.vo.channel.SmsChannelResp;


/**
 * 短信渠道（自定义渠道，云厂商渠道的扩展） 接口
 *
 * @author moushaokun
 * @since time: 2023-03-17 10:08
 */
public interface SmsChannelService {

    /**
     * 创建/更新短信渠道
     *
     * @param req 创建/更新信息
     * @return 编号
     */
    Long createOrUpdateSmsChannel(SmsChannelCreateOrUpdateReq req);

    /**
     * 删除短信渠道
     *
     * @param id 编号
     */
    void deleteSmsChannel(Long id);

    /**
     * 获得短信渠道
     *
     * @param id 编号
     * @return 短信渠道
     */
    SmsChannelResp findSmsChannel(Long id);

    /**
     * 获得短信渠道列表
     *
     * @param ids 编号
     * @return 短信渠道列表
     */
    List<SmsChannelResp> findSmsChannelList(Collection<Long> ids);

    /**
     * 获得短信渠道分页
     *
     * @param req 分页查询
     * @return 短信渠道分页
     */
    PageResult<SmsChannelResp> findSmsChannelPage(SmsChannelPageReq req);

}
