package org.sophon.module.sms.api;

import org.sophon.module.sms.api.vo.code.SmsCodeSendReq;
import org.sophon.module.sms.api.vo.code.SmsCodeUseReq;
import org.sophon.module.sms.api.vo.code.SmsCodeValidateReq;

/**
 * 短信验证码 接口
 *
 * @author moushaokun
 * @since time: 2023-03-13 10:53
 */
public interface SmsCodeService {

    /**
     * 创建短信验证码，并进行发送
     *
     * @param req 发送请求
     * @return 验证码，以备业务使用
     */
    String sendSmsCode(SmsCodeSendReq req);

    /**
     * 验证短信验证码，并进行使用
     *
     * @param req 使用请求
     */
    void useSmsCode(SmsCodeUseReq req);

    /**
     * 检查验证码是否有效
     *
     * @param req 校验请求
     */
    void validateSmsCode(SmsCodeValidateReq req);

}
