package org.sophon.module.sms.api;

import java.util.Collection;
import java.util.List;

import org.sophon.commons.pager.PageResult;
import org.sophon.module.sms.api.vo.template.SmsTemplateCreateOrUpdateReq;
import org.sophon.module.sms.api.vo.template.SmsTemplatePageReq;
import org.sophon.module.sms.api.vo.template.SmsTemplateResp;


/**
 * 短信模板（自定义模板，云厂商模板的扩展） 接口
 *
 * @author moushaokun
 * @since time: 2023-03-17 10:08
 */
public interface SmsTemplateService {

    /**
     * 创建/更新短信模板
     *
     * @param req 创建/修改请求
     * @return 编号
     */
    Long createOrUpdateSmsTemplate(SmsTemplateCreateOrUpdateReq req);

    /**
     * 删除短信模板
     *
     * @param id 编号
     */
    void deleteSmsTemplate(Long id);

    /**
     * 获得短信模板
     *
     * @param code 模板编码
     * @return 短信模板
     */
    SmsTemplateResp findSmsTemplate(String code);

    /**
     * 获得短信模板
     *
     * @param id 编号
     * @return 短信模板
     */
    SmsTemplateResp findSmsTemplate(Long id);

    /**
     * 获得短信模板列表
     *
     * @param ids 编号
     * @return 短信模板列表
     */
    List<SmsTemplateResp> findSmsTemplateList(Collection<Long> ids);

    /**
     * 获得短信模板分页
     *
     * @param req 分页查询
     * @return 短信模板分页
     */
    PageResult<SmsTemplateResp> findSmsTemplatePage(SmsTemplatePageReq req);

}
