package org.sophon.module.sms.api.vo.channel;

import java.io.Serializable;
import java.util.Map;

import org.sophon.commons.enums.SwitchStatusEnum;
import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;
import org.sophon.module.sms.commons.enunms.SmsChannelEnum;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 短信渠道 新增/更新请求
 *
 * @author moushaokun
 * @since time: 2023-03-13 10:53
 */
@Data
@Accessors(chain = true)
public class SmsChannelCreateOrUpdateReq implements Serializable {
    private static final long   serialVersionUID = -4793459236816277546L;

    /**
     * 渠道编号
     */
    private Long                id;
    /**
     * 渠道编码
     *
     * 枚举 {@link SmsChannelEnum#getCode()}
     */
    private String              code;
    /**
     * 短信签名
     */
    private String              signature;
    /**
     * 启用状态
     *
     * 枚举 {@link SwitchStatusEnum#getStatusCode()}
     */
    private Integer             status;
    /**
     * 短信 API 的账号
     */
    private String              apiKey;
    /**
     * 短信 API 的密钥
     */
    private String              apiSecret;
    /**
     * 短信 API 的其他属性
     */
    private Map<String, Object> apiExtras;
    /**
     * 操作人Id
     */
    private String              optUserId;
    /**
     * 短信发送回调 URL
     */
    private String              callbackUrl;
    /**
     * 备注
     */
    private String              remark;

    public static void check(SmsChannelCreateOrUpdateReq req){
        AssertUtil.assertNotNull(req, SmsErrorCodeConstants.PARAM_INVALID, "渠道创建或更新请求不能为空");
        AssertUtil.assertNotBlank(req.getCode(), SmsErrorCodeConstants.PARAM_INVALID, "渠道编码不能为空");
        AssertUtil.assertNotBlank(req.getSignature(), SmsErrorCodeConstants.PARAM_INVALID, "短信签名不能为空");
        AssertUtil.assertNotNull(req.getStatus(), SmsErrorCodeConstants.PARAM_INVALID, "启用状态不能为空");
        AssertUtil.assertNotBlank(req.getApiKey(), SmsErrorCodeConstants.PARAM_INVALID, "短信API账号不能为空");
        AssertUtil.assertNotBlank(req.getApiSecret(), SmsErrorCodeConstants.PARAM_INVALID, "短信API秘钥不能为空");
        AssertUtil.assertNotBlank(req.getOptUserId(), SmsErrorCodeConstants.PARAM_INVALID, "操作人不能为空");
    }

}
