package org.sophon.module.sms.api.vo.channel;

import java.util.Date;
import java.util.List;

import org.sophon.commons.enums.SwitchStatusEnum;
import org.sophon.commons.pager.PageParam;
import org.sophon.commons.pager.SortingField;
import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;
import org.sophon.module.sms.commons.enunms.SmsChannelEnum;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 短信渠道 分页查询请求
 *
 * @author moushaokun
 * @since time: 2023-03-13 10:53
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Accessors(chain = true)
public class SmsChannelPageReq extends PageParam {
    private static final long  serialVersionUID = 886501403944750073L;

    /**
     * 渠道编码
     *
     * 枚举 {@link SmsChannelEnum#getCode()}
     */
    private String             code;
    /**
     * 短信签名, like
     */
    private String             signature;
    /**
     * 启用状态
     *
     * 枚举 {@link SwitchStatusEnum#getStatusCode()}
     */
    private Integer            status;
    /**
     * 创建时间范围-开始
     */
    private Date               beginCreateTime;
    /**
     * 创建时间范围-结束
     */
    private Date               endCreateTime;
    /**
     * 排序字段
     */
    private List<SortingField> sortingFields;

    public static void check(SmsChannelPageReq req){
        AssertUtil.assertNotNull(req, SmsErrorCodeConstants.PARAM_INVALID, "短信渠道分页查询请求不能为空");
    }

}
