package org.sophon.module.sms.api.vo.channel;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

import org.sophon.commons.enums.SwitchStatusEnum;
import org.sophon.module.sms.commons.enunms.SmsChannelEnum;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 短信渠道 响应对象
 *
 * @author moushaokun
 * @since time: 2023-03-13 10:53
 */
@Data
@Accessors(chain = true)
public class SmsChannelResp implements Serializable {
    private static final long   serialVersionUID = -2028181896114797855L;

    /**
     * 渠道编号
     */
    private Long                id;
    /**
     * 渠道编码
     *
     * 枚举 {@link SmsChannelEnum#getCode()}
     */
    private String              code;
    /**
     * 短信签名
     */
    private String              signature;
    /**
     * 启用状态
     *
     * 枚举 {@link SwitchStatusEnum#getStatusCode()}
     */
    private Integer             status;
    /**
     * 短信 API 的账号
     */
    private String              apiKey;
    /**
     * 短信 API 的密钥
     */
    private String              apiSecret;
    /**
     * 短信 API 的其他属性
     */
    private Map<String, Object> apiExtras;
    /**
     * 短信发送回调 URL
     */
    private String              callbackUrl;
    /**
     * 备注
     */
    private String              remark;
    /**
     * 创建时间
     */
    private Date                createTime;
    /**
     * 创建者ID
     */
    private String              creator;
    /**
     * 最后更新时间
     */
    private Date                updateTime;
    /**
     * 更新者ID
     */
    private String              updater;
}
