package org.sophon.module.sms.api.vo.code;

import java.time.Duration;

/**
 * 短信验证码配置
 *
 * @author moushaokun
 * @since time: 2023-03-17 10:08
 */
public interface SmsCodeProperties {

    /**
     * 过期时间
     * @return Duration
     */
    Duration getExpireTimes();
    /**
     * 短信发送频率
     * @return Duration
     */
    Duration getSendFrequency();
    /**
     * 每日发送最大数量
     * @return Integer
     */
    Integer  getSendMaximumQuantityPerDay();
    /**
     * 验证码最小值
     * @return Integer
     */
    Integer  getBeginCode();
    /**
     * 验证码最大值
     * @return Integer
     */
    Integer  getEndCode();
    /**
     * 验证码参数名
     * @return String
     */
    String   getParamName();
}