package org.sophon.module.sms.api.vo.code;

import java.io.Serializable;

import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.api.ext.SmsCodeScene;
import org.sophon.module.sms.api.vo.template.SmsTemplateResp;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 短信验证码 发送请求
 *
 * @author moushaokun
 * @since time: 2023-03-13 10:53
 */
@Data
@Accessors(chain = true)
public class SmsCodeSendReq implements Serializable {
    private static final long serialVersionUID = -5816611534042490170L;
    /**
     * 手机号
     */
    private String            mobile;
    /**
     * 发送场景
     * 接口 {@link SmsCodeScene#getCode()}
     */
    private Integer           scene;
    /**
     * 发送 IP
     */
    private String            createIp;
    /**
     * 用户唯一编号
     */
    private String            userId;
    /**
     * 模板编码 {@link SmsTemplateResp#getCode()}
     */
    private String            templateCode;

    public static void check(SmsCodeSendReq req){
        AssertUtil.assertNotNull(req, SmsErrorCodeConstants.PARAM_INVALID, "短信验证码发送请求不能为空");
        AssertUtil.assertNotBlank(req.getMobile(), SmsErrorCodeConstants.PARAM_INVALID, "手机号不能为空");
        AssertUtil.assertNotNull(req.getScene(), SmsErrorCodeConstants.PARAM_INVALID, "发送场景不能为空");
        AssertUtil.assertTrue(req.getScene() >= 0 && req.getScene() <= 9999, SmsErrorCodeConstants.PARAM_INVALID, "发送场景的范围只能在0~9999");
        AssertUtil.assertNotBlank(req.getCreateIp(), SmsErrorCodeConstants.PARAM_INVALID, "发送IP不能为空");
        AssertUtil.assertNotBlank(req.getUserId(), SmsErrorCodeConstants.PARAM_INVALID, "用户编号不能为空");
        AssertUtil.assertNotBlank(req.getTemplateCode(), SmsErrorCodeConstants.PARAM_INVALID, "短信模板编码不能为空");
    }
}
