package org.sophon.module.sms.api.vo.code;

import java.io.Serializable;

import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.api.ext.SmsCodeScene;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 短信验证码 使用请求
 *
 * @author moushaokun
 * @since time: 2023-03-13 10:53
 */
@Data
@Accessors(chain = true)
public class SmsCodeUseReq implements Serializable {
    private static final long serialVersionUID = 72090628190297386L;
    /**
     * 手机号
     */
    private String            mobile;
    /**
     * 发送场景
     * 接口 {@link SmsCodeScene#getCode()}
     */
    private Integer           scene;
    /**
     * 验证码
     */
    private String            code;
    /**
     * 使用 IP
     */
    private String            usedIp;

    public static void check(SmsCodeUseReq req){
        AssertUtil.assertNotNull(req, SmsErrorCodeConstants.PARAM_INVALID, "短信验证码使用请求不能为空");
        AssertUtil.assertNotBlank(req.getMobile(), SmsErrorCodeConstants.PARAM_INVALID, "手机号不能为空");
        AssertUtil.assertNotNull(req.getScene(), SmsErrorCodeConstants.PARAM_INVALID, "发送场景不能为空");
        AssertUtil.assertTrue(req.getScene() >= 0 && req.getScene() <= 9999, SmsErrorCodeConstants.PARAM_INVALID, "发送场景的范围只能在0~9999");
        AssertUtil.assertNotBlank(req.getCode(), SmsErrorCodeConstants.PARAM_INVALID, "验证码不能为空");
        AssertUtil.assertNotBlank(req.getUsedIp(), SmsErrorCodeConstants.PARAM_INVALID, "使用IP不能为空");
    }
}
