package org.sophon.module.sms.api.vo.log;

import java.util.Date;
import java.util.List;

import org.sophon.commons.pager.PageParam;
import org.sophon.commons.pager.SortingField;
import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.api.enums.SmsReceiveStatusEnum;
import org.sophon.module.sms.api.enums.SmsSendStatusEnum;
import org.sophon.module.sms.api.vo.channel.SmsChannelResp;
import org.sophon.module.sms.api.vo.template.SmsTemplateResp;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 短信日志 分页查询请求对象
 * @author moushaokun
 * @since time: 2023-03-17 10:08
 */
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Data
@Accessors(chain = true)
public class SmsLogPageReq extends PageParam {
    private static final long  serialVersionUID = 3768531352963135190L;
    /**
     * 短信渠道编号
     *
     * 关联 {@link SmsChannelResp#getId()}
     */
    private Long               channelId;
    /**
     * 短信渠道编码
     *
     * 冗余 {@link SmsChannelResp#getCode()}
     */
    private String             channelCode;
    /**
     * 模板编号
     *
     * 关联 {@link SmsTemplateResp#getId()}
     */
    private Long               templateId;
    /**
     * 模板编码
     *
     * 冗余 {@link SmsTemplateResp#getCode()}
     */
    private String             templateCode;
    /**
     * 短信类型
     *
     * 冗余 {@link SmsTemplateResp#getType()}
     */
    private Integer            templateType;
    /**
     * api模板编号
     */
    private String             apiTemplateId;
    /**
     * 手机号, like
     */
    private String             mobile;
    /**
     * 用户编号
     */
    private String             userId;
    /**
     * 发送状态
     *
     * 枚举 {@link SmsSendStatusEnum#getStatus()}
     */
    private Integer            sendStatus;
    /**
     * 发送时间范围-开始
     */
    private Date               beginSendTime;
    /**
     * 发送时间范围-结束
     */
    private Date               endSendTime;
    /**
     * 接收状态
     *
     * 枚举 {@link SmsReceiveStatusEnum#getStatus()}
     */
    private Integer            receiveStatus;
    /**
     * 接收时间范围-开始
     */
    private Date               beginReceiveTime;
    /**
     * 接收时间范围-结束
     */
    private Date               endReceiveTime;
    /**
     * 排序字段
     */
    private List<SortingField> sortingFields;

    public static void check(SmsLogPageReq req){
        AssertUtil.assertNotNull(req, SmsErrorCodeConstants.PARAM_INVALID, "短信日志查询请求不能为空");
    }
}
