package org.sophon.module.sms.api.vo.log;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

import org.sophon.module.sms.api.enums.SmsReceiveStatusEnum;
import org.sophon.module.sms.api.enums.SmsSendStatusEnum;
import org.sophon.module.sms.api.vo.channel.SmsChannelResp;
import org.sophon.module.sms.api.vo.template.SmsTemplateResp;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 短信日志 查询响应对象
 * @author moushaokun
 * @since time: 2023-03-17 10:08
 */
@Data
@Accessors(chain = true)
public class SmsLogResp implements Serializable {
    private static final long   serialVersionUID = 2315841968510527553L;
    /**
     * 日志编号
     */
    private Long                id;
    /**
     * 短信渠道编号
     *
     * 关联 {@link SmsChannelResp#getId()}
     */
    private Long                channelId;
    /**
     * 短信渠道编码
     *
     * 冗余 {@link SmsChannelResp#getCode()}
     */
    private String              channelCode;
    /**
     * 模板编号
     *
     * 关联 {@link SmsTemplateResp#getId()}
     */
    private Long                templateId;
    /**
     * 模板编码
     *
     * 冗余 {@link SmsTemplateResp#getCode()}
     */
    private String              templateCode;
    /**
     * 短信类型
     *
     * 冗余 {@link SmsTemplateResp#getType()}
     */
    private Integer             templateType;
    /**
     * 模板内容
     */
    private String              templateContent;
    /**
     * 模板参数
     */
    private Map<String, Object> templateParams;
    /**
     * api模板编号
     */
    private String              apiTemplateId;
    /**
     * 手机号
     */
    private String              mobile;
    /**
     * 用户编号
     */
    private String              userId;
    /**
     * 发送状态
     *
     * 枚举 {@link SmsSendStatusEnum#getStatus()}
     */
    private Integer             sendStatus;
    /**
     * 发送时间
     */
    private Date                sendTime;
    /**
     * 发送结果的编码
     *
     * 枚举 {@link SmsErrorCodeConstants}
     */
    private Integer             sendCode;
    /**
     * 发送结果的提示
     *
     * 一般情况下，使用 {@link SmsErrorCodeConstants}
     * 异常情况下，通过格式化 Exception 的提示存储
     */
    private String              sendMsg;
    /**
     * 短信 API 发送结果的编码
     *
     * 由于第三方的错误码可能是字符串，所以使用 String 类型
     */
    private String              apiSendCode;
    /**
     * 短信 API 发送失败的提示
     */
    private String              apiSendMsg;
    /**
     * 短信 API 发送返回的唯一请求 ID
     *
     * 用于和短信 API 进行定位于排错
     */
    private String              apiRequestId;
    /**
     * 短信 API 发送返回的序号
     *
     * 用于和短信 API 平台的发送记录关联
     */
    private String              apiSerialNo;
    /**
     * 接收状态
     *
     * 枚举 {@link SmsReceiveStatusEnum#getStatus()}
     */
    private Integer             receiveStatus;
    /**
     * 接收时间
     */
    private Date                receiveTime;
    /**
     * 短信 API 接收结果的编码
     */
    private String              apiReceiveCode;
    /**
     * 短信 API 接收结果的提示
     */
    private String              apiReceiveMsg;

}
