package org.sophon.module.sms.api.vo.send;

import java.io.Serializable;

import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;
import org.sophon.module.sms.commons.enunms.SmsChannelEnum;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 短信接收结果处理 请求
 * @author moushaokun
 * @since time: 2023-03-17 10:08
 */
@Data
@Accessors(chain = true)
public class SmsReceiveHandleReq implements Serializable {
    private static final long serialVersionUID = 5246537891161792826L;

    /**
     * 渠道编码 {@link SmsChannelEnum#getCode()}
     */
    private String            channelCode;
    /**
     * 接收结果内容
     */
    private String            text;

    public static void check(SmsReceiveHandleReq req){
        AssertUtil.assertNotNull(req, SmsErrorCodeConstants.PARAM_INVALID, "短信接收结果处理不能为空");
        AssertUtil.assertNotBlank(req.getChannelCode(), SmsErrorCodeConstants.PARAM_INVALID, "短信渠道编码不能为空");
        AssertUtil.assertNotBlank(req.getText(), SmsErrorCodeConstants.PARAM_INVALID, "短信接收结果不能为空");
    }

}
