package org.sophon.module.sms.api.vo.send;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.api.vo.template.SmsTemplateResp;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 短信发送 请求
 * @author moushaokun
 * @since time: 2023-03-17 10:08
 */
@Data
@Accessors(chain = true)
public class SmsSendReq implements Serializable {
    private static final long   serialVersionUID = 5246537891161792826L;

    /**
     * 手机号
     */
    private String              mobile;
    /**
     * 用户唯一编号
     */
    private String              userId;
    /**
     * 模板编码 {@link SmsTemplateResp#getCode()}
     */
    private String              templateCode;
    /**
     * 模板参数
     */
    private Map<String, Object> templateParams;

    public SmsSendReq addTemplateParam(String key, String value) {
        if (templateParams == null) {
            templateParams = new HashMap<>(4);
        }
        templateParams.put(key, value);
        return this;
    }

    public static void check(SmsSendReq req){
        AssertUtil.assertNotNull(req, SmsErrorCodeConstants.PARAM_INVALID, "短信发送请求不能为空");
        AssertUtil.assertNotBlank(req.getMobile(), SmsErrorCodeConstants.PARAM_INVALID, "手机号不能为空");
        AssertUtil.assertNotBlank(req.getUserId(), SmsErrorCodeConstants.PARAM_INVALID, "用户编号不能为空");
        AssertUtil.assertNotBlank(req.getTemplateCode(), SmsErrorCodeConstants.PARAM_INVALID, "短信模板编码不能为空");
    }

}
