package org.sophon.module.sms.api.vo.template;

import java.io.Serializable;

import org.sophon.commons.enums.SwitchStatusEnum;
import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.api.ext.SmsTemplateType;
import org.sophon.module.sms.api.vo.channel.SmsChannelResp;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 短信模板创建或修改 请求
 * @author moushaokun
 * @since time: 2023-03-17 10:08
 */
@Data
@Accessors(chain = true)
public class SmsTemplateCreateOrUpdateReq implements Serializable {
    private static final long serialVersionUID = -7063749645438900297L;

    /** 模板编号 */
    private Long              id;
    /**
     * 短信类型
     *
     * 接口 {@link SmsTemplateType#getCode()}
     */
    private Integer           type;
    /**
     * 启用状态
     *
     * 枚举 {@link SwitchStatusEnum#getStatusCode()}
     */
    private Integer           status;
    /**
     * 模板编码，保证唯一
     */
    private String            code;
    /**
     * 模板名称
     */
    private String            name;
    /**
     * 模板内容
     *
     * 内容的参数，使用 {} 包括，例如说 {name}
     */
    private String            content;

    /** api模板编号 */
    private String            apiTemplateId;

    /** 渠道ID {@link SmsChannelResp#getId()} */
    private Long              channelId;

    /**
     * 操作人Id
     */
    private String            optUserId;

    /** 备注 */
    private String            remark;

    public static void check(SmsTemplateCreateOrUpdateReq req){
        AssertUtil.assertNotNull(req, SmsErrorCodeConstants.PARAM_INVALID, "短信模板创建或修改请求不能为空");
        AssertUtil.assertNotNull(req.getType(), SmsErrorCodeConstants.PARAM_INVALID, "短信类型不能为空");
        AssertUtil.assertTrue(req.getType() >= 0 && req.getType() <= 9999, SmsErrorCodeConstants.PARAM_INVALID, "短信类型的范围只能在0~9999");
        AssertUtil.assertNotNull(req.getStatus(), SmsErrorCodeConstants.PARAM_INVALID, "开启状态不能为空");
        AssertUtil.assertNotBlank(req.getCode(), SmsErrorCodeConstants.PARAM_INVALID, "模板编码不能为空");
        AssertUtil.assertNotBlank(req.getName(), SmsErrorCodeConstants.PARAM_INVALID, "模板名称不能为空");
        AssertUtil.assertNotBlank(req.getContent(), SmsErrorCodeConstants.PARAM_INVALID, "模板内容不能为空");
        AssertUtil.assertNotBlank(req.getApiTemplateId(), SmsErrorCodeConstants.PARAM_INVALID, "API模板编号不能为空");
        AssertUtil.assertNotBlank(req.getOptUserId(), SmsErrorCodeConstants.PARAM_INVALID, "操作人不能为空");
        AssertUtil.assertNotNull(req.getChannelId(), SmsErrorCodeConstants.PARAM_INVALID, "渠道id不能为空");
    }
}
