package org.sophon.module.sms.api.vo.template;

import java.util.Date;
import java.util.List;

import org.sophon.commons.enums.SwitchStatusEnum;
import org.sophon.commons.pager.PageParam;
import org.sophon.commons.pager.SortingField;
import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.api.ext.SmsTemplateType;
import org.sophon.module.sms.api.vo.channel.SmsChannelResp;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 短信模板分页查询 请求
 * @author moushaokun
 * @since time: 2023-03-17 10:08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Accessors(chain = true)
public class SmsTemplatePageReq extends PageParam {
    private static final long  serialVersionUID = 4850451601096532200L;
    /**
     * 短信类型
     *
     * 接口 {@link SmsTemplateType#getCode()}
     */
    private Integer            type;
    /**
     * 启用状态
     *
     * 枚举 {@link SwitchStatusEnum#getStatusCode()}
     */
    private Integer            status;
    /**
     * 名称,like
     */
    private String             name;
    /**
     * 模板编码，保证唯一,like
     */
    private String             code;
    /**
     * 模板内容,like
     *
     * 内容的参数，使用 {} 包括，例如说 {name}
     */
    private String             content;

    /** api模板编号,like */
    private String             apiTemplateId;

    /** 渠道ID {@link SmsChannelResp#getId()} */
    private Long               channelId;

    /**
     * 创建时间范围-开始
     */
    private Date               beginCreateTime;
    /**
     * 创建时间范围-结束
     */
    private Date               endCreateTime;
    /**
     * 排序字段
     */
    private List<SortingField> sortingFields;

    public static void check(SmsTemplatePageReq req) {
        AssertUtil.assertNotNull(req, SmsErrorCodeConstants.PARAM_INVALID, "短信模板分页查询请求不能为空");
    }
}
