package org.sophon.module.sms.api.vo.template;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.sophon.commons.enums.SwitchStatusEnum;
import org.sophon.module.sms.api.ext.SmsTemplateType;
import org.sophon.module.sms.api.vo.channel.SmsChannelResp;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 短信模板 响应对象
 * @author moushaokun
 * @since time: 2023-03-17 10:08
 */
@Data
@Accessors(chain = true)
public class SmsTemplateResp implements Serializable {
    private static final long serialVersionUID = -1455703334324189544L;

    /**
     * 模板编号
     */
    private Long              id;
    /**
     * 短信类型
     *
     * 接口 {@link SmsTemplateType#getCode()}
     */
    private Integer           type;
    /**
     * 启用状态
     *
     * 枚举 {@link SwitchStatusEnum#getStatusCode()}
     */
    private Integer           status;
    /**
     * 模板编码，保证唯一
     */
    private String            code;
    /**
     * 模板名称
     */
    private String            name;
    /**
     * 模板内容
     */
    private String            content;
    /**
     * 模板参数
     */
    private List<String>      params;
    /**
     * 备注
     */
    private String            remark;
    /**
     * 短信 API 的模板编号
     */
    private String            apiTemplateId;
    /**
     * 短信渠道编号
     *
     * 关联 {@link SmsChannelResp#getId()}
     */
    private Long              channelId;
    /**
     * 短信渠道编码
     *
     * 冗余 {@link SmsChannelResp#getCode()}
     */
    private String            channelCode;
    /**
     * 创建时间
     */
    private Date              createTime;
    /**
     * 创建者ID
     */
    private String            creator;
    /**
     * 最后更新时间
     */
    private Date              updateTime;
    /**
     * 更新者ID
     */
    private String            updater;

}
