/*
 * Decompiled with CFR 0.152.
 */
package com.lwq.fast.log.fastlogclient.log4j2.appender;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.lwq.fast.log.fastlogclient.log4j2.appender.util.MessageUtil;
import com.lwq.fast.log.fastlogcore.client.AbstractClient;
import com.lwq.fast.log.fastlogcore.client.rabbitmq.RabbitMqClient;
import com.lwq.fast.log.fastlogcore.entity.Message;
import com.lwq.fast.log.fastlogcore.util.ThreadPoolUtil;
import com.lwq.fast.log.fastlogcore.work.MessageCollection;
import java.io.Serializable;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="Log4jRabbitMqAppender", category="Core", elementType="appender", printObject=true)
public class RabbitMqAppender
extends AbstractAppender {
    private String appName;
    private String env;
    private String host;
    private int port;
    private String virtualHost;
    private String username;
    private String password;

    protected RabbitMqAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String appName, String env, String host, int port, String virtualHost, String username, String password) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
        this.appName = appName;
        this.env = env;
        this.host = host;
        this.port = port;
        this.virtualHost = virtualHost;
        this.username = username;
        this.password = password;
        RabbitMqClient instance = RabbitMqClient.getInstance((String)host, (int)port, (String)virtualHost, (String)username, (String)password);
        if (ObjectUtil.isNotNull((Object)instance)) {
            ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getThreadPoolExecutor();
            threadPoolExecutor.execute(() -> MessageCollection.messageCollect((AbstractClient)instance));
        }
    }

    public void append(LogEvent logEvent) {
        Message message = MessageUtil.formatMessage(this.appName, this.env, logEvent);
        if (ObjectUtil.isNotNull((Object)message)) {
            MessageCollection.addMessage2Queue((String)JSON.toJSONString((Object)message));
        }
    }

    @PluginFactory
    public static RabbitMqAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="filter") Filter filter, @PluginElement(value="layout") Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginAttribute(value="appName") String appName, @PluginAttribute(value="env") String env, @PluginAttribute(value="host") String host, @PluginAttribute(value="port") int port, @PluginAttribute(value="virtualHost") String virtualHost, @PluginAttribute(value="username") String username, @PluginAttribute(value="password") String password) {
        if (null == name) {
            LOGGER.error("name \u4e3a\u7a7a");
            return null;
        }
        if (null == layout) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new RabbitMqAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, appName, env, host, port, virtualHost, username, password);
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

