/*
 * Decompiled with CFR 0.152.
 */
package com.lwq.fast.log.fastlogclient.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.lwq.fast.log.fastlogclient.logback.appender.util.MessageUtil;
import com.lwq.fast.log.fastlogcore.client.AbstractClient;
import com.lwq.fast.log.fastlogcore.client.rabbitmq.RabbitMqClient;
import com.lwq.fast.log.fastlogcore.entity.Message;
import com.lwq.fast.log.fastlogcore.util.ThreadPoolUtil;
import com.lwq.fast.log.fastlogcore.work.MessageCollection;
import java.util.concurrent.ThreadPoolExecutor;

public class RabbitMqAppender
extends AppenderBase<ILoggingEvent> {
    private String appName;
    private String env;
    private String host;
    private int port;
    private String virtualHost;
    private String username;
    private String password;

    protected void append(ILoggingEvent iLoggingEvent) {
        Message message = MessageUtil.formatMessage(this.appName, this.env, iLoggingEvent);
        if (ObjectUtil.isNotNull((Object)message)) {
            MessageCollection.addMessage2Queue((String)JSON.toJSONString((Object)message));
        }
    }

    public void stop() {
        super.stop();
    }

    public void start() {
        super.start();
        RabbitMqClient instance = RabbitMqClient.getInstance((String)this.host, (int)this.port, (String)this.virtualHost, (String)this.username, (String)this.password);
        if (ObjectUtil.isNotNull((Object)instance)) {
            ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getThreadPoolExecutor();
            threadPoolExecutor.execute(() -> MessageCollection.messageCollect((AbstractClient)instance));
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }
}

