/*
 * Decompiled with CFR 0.152.
 */
package com.lwq.fast.log.fastlogclient.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.lwq.fast.log.fastlogclient.logback.appender.util.MessageUtil;
import com.lwq.fast.log.fastlogcore.client.AbstractClient;
import com.lwq.fast.log.fastlogcore.client.redis.RedisClient;
import com.lwq.fast.log.fastlogcore.entity.Message;
import com.lwq.fast.log.fastlogcore.util.ThreadPoolUtil;
import com.lwq.fast.log.fastlogcore.work.MessageCollection;
import java.util.concurrent.ThreadPoolExecutor;

public class RedisAppender
extends AppenderBase<ILoggingEvent> {
    private String appName;
    private String env;
    private String host;
    private int port;
    private String auth;

    protected void append(ILoggingEvent iLoggingEvent) {
        Message message = MessageUtil.formatMessage(this.appName, this.env, iLoggingEvent);
        if (ObjectUtil.isNotNull((Object)message)) {
            MessageCollection.addMessage2Queue((String)JSON.toJSONString((Object)message));
        }
    }

    public void start() {
        super.start();
        RedisClient instance = RedisClient.getInstance((String)this.host, (int)this.port, (String)this.auth);
        if (ObjectUtil.isNotNull((Object)instance)) {
            ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getThreadPoolExecutor();
            threadPoolExecutor.execute(() -> MessageCollection.messageCollect((AbstractClient)instance));
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getAuth() {
        return this.auth;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }
}

