/*
 * Decompiled with CFR 0.152.
 */
package com.franklin.ideaplugin.easytesting.spring.controller;

import com.franklin.ideaplugin.easytesting.core.log.ILogger;
import com.franklin.ideaplugin.easytesting.core.log.LoggerFactory;
import com.franklin.ideaplugin.easytesting.core.rpc.NettyServer;
import com.franklin.ideaplugin.easytesting.core.rpc.entity.ETRsp;
import com.franklin.ideaplugin.easytesting.core.rpc.entity.MethodInvokeData;
import com.franklin.ideaplugin.easytesting.core.utils.JsonUtils;
import com.franklin.ideaplugin.easytesting.core.utils.MethodUtils;
import com.franklin.ideaplugin.easytesting.spring.invoke.SpringMethodInvoker;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnBean(value={SpringMethodInvoker.class})
public class EasyTestingControllerMethodController {
    private static final ILogger log = LoggerFactory.getLogger(NettyServer.class);
    private final SpringMethodInvoker springMethodInvoker;

    @PostMapping(value={"/easy-testing-execute"})
    public ETRsp<String> execute(@RequestBody MethodInvokeData methodInvokeData) {
        try {
            Class<?> targetClass = Class.forName(methodInvokeData.getClassQualifiedName());
            Class[] paramTypes = MethodUtils.resolveParamTypes((MethodInvokeData)methodInvokeData);
            Method declaredMethod = targetClass.getDeclaredMethod(methodInvokeData.getMethodName(), paramTypes);
            declaredMethod.setAccessible(true);
            Object[] params = methodInvokeData.getParameterMap().values().stream().map(MethodUtils::parseValue).toArray();
            methodInvokeData.setHeaderMap(new LinkedHashMap());
            Object result = this.springMethodInvoker.invoke(methodInvokeData, targetClass, declaredMethod, params);
            log.info("Easy-Testing -> method execute result : \n{}", new Object[]{JsonUtils.toJSONString((Object)result)});
            return ETRsp.success((Object)"success");
        }
        catch (Exception e) {
            log.error("Easy-Testing -> method execute fail", (Throwable)e);
            return ETRsp.fail((Object)"error");
        }
    }

    public EasyTestingControllerMethodController(SpringMethodInvoker springMethodInvoker) {
        this.springMethodInvoker = springMethodInvoker;
    }
}

