/*
 * Decompiled with CFR 0.152.
 */
package com.franklin.ideaplugin.easytesting.spring.invoke;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.franklin.ideaplugin.easytesting.core.invoke.IMethodInvoker;
import com.franklin.ideaplugin.easytesting.core.invoke.InstanceMethodInvoker;
import com.franklin.ideaplugin.easytesting.core.invoke.StaticMethodInvoker;
import com.franklin.ideaplugin.easytesting.core.log.ILogger;
import com.franklin.ideaplugin.easytesting.core.log.LoggerFactory;
import com.franklin.ideaplugin.easytesting.core.rpc.NettyServer;
import com.franklin.ideaplugin.easytesting.core.rpc.entity.MethodInvokeData;
import com.franklin.ideaplugin.easytesting.core.thread.EasyTestingThreadPool;
import com.franklin.ideaplugin.easytesting.core.utils.JsonUtils;
import com.franklin.ideaplugin.easytesting.core.utils.MethodUtils;
import com.franklin.ideaplugin.easytesting.spring.utils.SpringUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;

public class SpringMethodInvoker
implements IMethodInvoker {
    private static final ILogger log = LoggerFactory.getLogger(NettyServer.class);
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient okHttpClient;
    @Value(value="${server.servlet.path:null}")
    private String servletPath;
    @Value(value="${server.servlet.context-path:null}")
    private String servletContextPath;
    @Value(value="${server.port:8080}")
    private String port;
    private final IMethodInvoker staticMethodInvoker;
    private final IMethodInvoker instanceMethodInvoker;

    public SpringMethodInvoker() {
        this.okHttpClient = new OkHttpClient.Builder().build();
        this.staticMethodInvoker = new StaticMethodInvoker();
        this.instanceMethodInvoker = new InstanceMethodInvoker();
    }

    public Object invoke(MethodInvokeData methodInvokeData, Class<?> targetClass, Method targetMethod, Object[] params) throws Exception {
        if (CollectionUtil.isNotEmpty((Map)methodInvokeData.getHeaderMap())) {
            return this.invokeControllerMethod(methodInvokeData);
        }
        if (MethodUtils.isStaticMethod((Method)targetMethod)) {
            return this.staticMethodInvoker.invoke(methodInvokeData, targetClass, targetMethod, params);
        }
        Object bean = null;
        try {
            bean = SpringUtil.getBean(targetClass);
            return targetMethod.invoke(bean, params);
        }
        catch (BeansException e) {
            log.info("Easy-Testing -> spring bean {} not found,try instance method ", new Object[]{targetClass.getName()});
            return this.instanceMethodInvoker.invoke(methodInvokeData, targetClass, targetMethod, params);
        }
        catch (Exception e) {
            log.error("Easy-Testing -> method execute fail ", (Throwable)e);
            return null;
        }
    }

    private Object invokeControllerMethod(MethodInvokeData methodInvokeData) {
        Request.Builder builder = new Request.Builder();
        String url = "http://localhost:" + this.port + this.getPrefix() + "/easy-testing-execute";
        builder.url(url).post(RequestBody.create((MediaType)APPLICATION_JSON, (String)JsonUtils.toJSONString((Object)methodInvokeData)));
        LinkedHashMap headerMap = methodInvokeData.getHeaderMap();
        if (CollectionUtil.isNotEmpty((Map)headerMap)) {
            headerMap.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        Request request = builder.build();
        EasyTestingThreadPool.getBizThreadPool().execute(() -> {
            Response response = null;
            try {
                response = this.okHttpClient.newCall(request).execute();
            }
            catch (IOException iOException) {
            }
            finally {
                if (Objects.nonNull(response)) {
                    response.close();
                }
            }
        });
        return null;
    }

    private String getPrefix() {
        if (StrUtil.isNotBlank((CharSequence)this.servletPath)) {
            return this.servletPath;
        }
        if (StrUtil.isNotBlank((CharSequence)this.servletContextPath)) {
            return this.servletContextPath;
        }
        return "";
    }

    public SpringMethodInvoker(OkHttpClient okHttpClient, IMethodInvoker staticMethodInvoker, IMethodInvoker instanceMethodInvoker) {
        this.okHttpClient = okHttpClient;
        this.staticMethodInvoker = staticMethodInvoker;
        this.instanceMethodInvoker = instanceMethodInvoker;
    }
}

