/*
 * Decompiled with CFR 0.152.
 */
package com.franklin.ideaplugin.easytesting.spring.lifecycle;

import com.franklin.ideaplugin.easytesting.core.invoke.IMethodInvoker;
import com.franklin.ideaplugin.easytesting.core.invoke.MethodInvokerRegistry;
import com.franklin.ideaplugin.easytesting.core.registry.FileRegistry;
import com.franklin.ideaplugin.easytesting.core.rpc.NettyServer;
import com.franklin.ideaplugin.easytesting.spring.config.EasyTestingProperties;
import com.franklin.ideaplugin.easytesting.spring.invoke.SpringMethodInvoker;
import com.franklin.ideaplugin.easytesting.spring.utils.SpringUtil;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class EasyTestingLifeCycle
implements InitializingBean,
DisposableBean {
    private final SpringMethodInvoker springMethodInvoker;
    private final NettyServer nettyServer;
    private final EasyTestingProperties easyTestingProperties;

    public void afterPropertiesSet() throws Exception {
        if (!this.nettyServer.isEnable()) {
            return;
        }
        MethodInvokerRegistry.addMethodInvoker((IMethodInvoker)this.springMethodInvoker);
        this.nettyServer.start();
    }

    public void destroy() throws Exception {
        FileRegistry.shutDown((String)SpringUtil.getAppName());
    }

    public EasyTestingLifeCycle(SpringMethodInvoker springMethodInvoker, NettyServer nettyServer, EasyTestingProperties easyTestingProperties) {
        this.springMethodInvoker = springMethodInvoker;
        this.nettyServer = nettyServer;
        this.easyTestingProperties = easyTestingProperties;
    }
}

