/*
 * Decompiled with CFR 0.152.
 */
package com.franklin.ideaplugin.easytesting.spring.registry;

import cn.hutool.core.util.ArrayUtil;
import com.franklin.ideaplugin.easytesting.core.registry.FileRegistry;
import com.franklin.ideaplugin.easytesting.core.utils.ReflectionUtils;
import com.franklin.ideaplugin.easytesting.spring.config.EasyTestingProperties;
import com.franklin.ideaplugin.easytesting.spring.registry.SpringLibFileRegistry;
import com.franklin.ideaplugin.easytesting.spring.utils.SpringUtil;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class SpringFileRegistry
implements BeanPostProcessor,
InitializingBean {
    private final int port;
    private final EasyTestingProperties easyTestingProperties;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClass = bean.getClass();
        String appName = SpringUtil.getAppName();
        FileRegistry.registryServer((String)appName, beanClass, (int)this.port);
        List classAllSuperClasses = ReflectionUtils.getClassAllSuperClasses(beanClass);
        for (Class classAllSuperClass : classAllSuperClasses) {
            FileRegistry.registryServer((String)appName, (Class)classAllSuperClass, (int)this.port);
        }
        Object[] interfaces = beanClass.getInterfaces();
        if (ArrayUtil.isNotEmpty((Object[])interfaces)) {
            for (Object anInterface : interfaces) {
                FileRegistry.registryServer((String)appName, (Class)anInterface, (int)this.port);
            }
        }
        return bean;
    }

    public void afterPropertiesSet() throws Exception {
        new SpringLibFileRegistry(this.port).registry();
    }

    public SpringFileRegistry(int port, EasyTestingProperties easyTestingProperties) {
        this.port = port;
        this.easyTestingProperties = easyTestingProperties;
    }
}

