/*
 * Decompiled with CFR 0.152.
 */
package com.franklin.ideaplugin.easytesting.spring.registry;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.net.URLDecoder;
import com.franklin.ideaplugin.easytesting.core.registry.FileRegistry;
import com.franklin.ideaplugin.easytesting.spring.utils.SpringUtil;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SpringLibFileRegistry {
    private static final Logger log = LoggerFactory.getLogger(SpringLibFileRegistry.class);
    private final int port;
    private static final String JRE_LIB = "jre/lib";

    public void registry() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources("classpath*:")) {
                if (!resource.isReadable()) continue;
                URL url = resource.getURL();
                String path = url.getPath();
                path = URLDecoder.decodeForPath((String)path, (Charset)StandardCharsets.UTF_8);
                File file = FileUtil.file((String)path);
                String filePath = file.getAbsolutePath();
                filePath = filePath.substring(0, filePath.length() - 1);
                filePath = filePath.replace("\\", "/");
                try {
                    if (filePath.contains(JRE_LIB)) {
                        int index = filePath.indexOf(JRE_LIB);
                        filePath = filePath.substring(0, index + JRE_LIB.length());
                    }
                    FileRegistry.registryServerForLib((String)SpringUtil.getAppName(), (String)filePath, (int)this.port);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SpringLibFileRegistry(int port) {
        this.port = port;
    }
}

